/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.testing;

import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class TestingSplit
implements ConnectorSplit {
    private static final HostAddress localHost = HostAddress.fromString((String)"127.0.0.1");
    private final NodeSelectionStrategy nodeSelectionStrategy;
    private final List<HostAddress> addresses;

    public static TestingSplit createLocalSplit() {
        return new TestingSplit(NodeSelectionStrategy.HARD_AFFINITY, (List<HostAddress>)ImmutableList.of((Object)localHost));
    }

    public static TestingSplit createEmptySplit() {
        return new TestingSplit(NodeSelectionStrategy.HARD_AFFINITY, (List<HostAddress>)ImmutableList.of());
    }

    public static TestingSplit createRemoteSplit() {
        return new TestingSplit(NodeSelectionStrategy.NO_PREFERENCE, (List<HostAddress>)ImmutableList.of());
    }

    @JsonCreator
    public TestingSplit(@JsonProperty(value="nodeSelectionStrategy") NodeSelectionStrategy nodeSelectionStrategy, @JsonProperty(value="addresses") List<HostAddress> addresses) {
        this.addresses = addresses;
        this.nodeSelectionStrategy = nodeSelectionStrategy;
    }

    @JsonProperty
    public NodeSelectionStrategy getNodeSelectionStrategy() {
        return this.nodeSelectionStrategy;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public List<HostAddress> getPreferredNodes(List<HostAddress> sortedCandidates) {
        return this.addresses;
    }

    public Object getInfo() {
        return this;
    }
}

