/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.BooleanType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class BooleanOperators {
    private static final Slice TRUE = Slices.copiedBuffer((String)"true", (Charset)StandardCharsets.US_ASCII);
    private static final Slice FALSE = Slices.copiedBuffer((String)"false", (Charset)StandardCharsets.US_ASCII);

    private BooleanOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equal(@SqlType(value="boolean") boolean left, @SqlType(value="boolean") boolean right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="boolean") boolean left, @SqlType(value="boolean") boolean right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="boolean") boolean left, @SqlType(value="boolean") boolean right) {
        return !left && right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="boolean") boolean left, @SqlType(value="boolean") boolean right) {
        return !left || right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="boolean") boolean left, @SqlType(value="boolean") boolean right) {
        return left && !right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="boolean") boolean left, @SqlType(value="boolean") boolean right) {
        return left || !right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="boolean") boolean value, @SqlType(value="boolean") boolean min, @SqlType(value="boolean") boolean max) {
        return value && max || !value && !min;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="double")
    public static double castToDouble(@SqlType(value="boolean") boolean value) {
        return value ? 1.0 : 0.0;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="real")
    public static long castToReal(@SqlType(value="boolean") boolean value) {
        return value ? (long)Float.floatToRawIntBits(1.0f) : (long)Float.floatToRawIntBits(0.0f);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="bigint")
    public static long castToBigint(@SqlType(value="boolean") boolean value) {
        return value ? 1L : 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="integer")
    public static long castToInteger(@SqlType(value="boolean") boolean value) {
        return value ? 1L : 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="smallint")
    public static long castToSmallint(@SqlType(value="boolean") boolean value) {
        return value ? 1L : 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="tinyint")
    public static long castToTinyint(@SqlType(value="boolean") boolean value) {
        return value ? 1L : 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToVarchar(@SqlType(value="boolean") boolean value) {
        return value ? TRUE : FALSE;
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="boolean") boolean value) {
        return value ? 1231L : 1237L;
    }

    @ScalarOperator(value=OperatorType.INDETERMINATE)
    @SqlType(value="boolean")
    public static boolean indeterminate(@SqlType(value="boolean") boolean value, @IsNull boolean isNull) {
        return isNull;
    }

    @SqlType(value="boolean")
    @ScalarFunction(visibility=SqlFunctionVisibility.HIDDEN)
    public static boolean not(@SqlType(value="boolean") boolean value) {
        return !value;
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    public static class BooleanDistinctFromOperator {
        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@SqlType(value="boolean") boolean left, @IsNull boolean leftNull, @SqlType(value="boolean") boolean right, @IsNull boolean rightNull) {
            if (leftNull != rightNull) {
                return true;
            }
            if (leftNull) {
                return false;
            }
            return BooleanOperators.notEqual(left, right);
        }

        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@BlockPosition @SqlType(value="boolean", nativeContainerType=boolean.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="boolean", nativeContainerType=boolean.class) Block right, @BlockIndex int rightPosition) {
            if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
                return true;
            }
            if (left.isNull(leftPosition)) {
                return false;
            }
            return BooleanOperators.notEqual(BooleanType.BOOLEAN.getBoolean(left, leftPosition), BooleanType.BOOLEAN.getBoolean(right, rightPosition));
        }
    }
}

