/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type.khyperloglog;

import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.type.khyperloglog.KHyperLogLog;
import com.facebook.presto.type.khyperloglog.KHyperLogLogState;
import com.facebook.presto.type.khyperloglog.KHyperLogLogStateSerializer;
import io.airlift.slice.Slice;
import io.airlift.slice.XxHash64;

@AggregationFunction(value="khyperloglog_agg")
public final class KHyperLogLogAggregationFunction {
    private static final KHyperLogLogStateSerializer SERIALIZER = new KHyperLogLogStateSerializer();

    private KHyperLogLogAggregationFunction() {
    }

    @InputFunction
    public static void input(@AggregationState KHyperLogLogState state, @SqlType(value="bigint") long value, @SqlType(value="bigint") long uii) {
        if (state.getKHLL() == null) {
            state.setKHLL(new KHyperLogLog());
        }
        state.getKHLL().add(value, uii);
    }

    @InputFunction
    @LiteralParameters(value={"x"})
    public static void input(@AggregationState KHyperLogLogState state, @SqlType(value="varchar(x)") Slice value, @SqlType(value="bigint") long uii) {
        if (state.getKHLL() == null) {
            state.setKHLL(new KHyperLogLog());
        }
        state.getKHLL().add(value, uii);
    }

    @InputFunction
    public static void input(@AggregationState KHyperLogLogState state, @SqlType(value="double") double value, @SqlType(value="bigint") long uii) {
        KHyperLogLogAggregationFunction.input(state, Double.doubleToLongBits(value), uii);
    }

    @InputFunction
    @LiteralParameters(value={"x"})
    public static void input(@AggregationState KHyperLogLogState state, @SqlType(value="bigint") long value, @SqlType(value="varchar(x)") Slice uii) {
        KHyperLogLogAggregationFunction.input(state, value, XxHash64.hash((Slice)uii));
    }

    @InputFunction
    @LiteralParameters(value={"x", "y"})
    public static void input(@AggregationState KHyperLogLogState state, @SqlType(value="varchar(x)") Slice value, @SqlType(value="varchar(y)") Slice uii) {
        KHyperLogLogAggregationFunction.input(state, value, XxHash64.hash((Slice)uii));
    }

    @InputFunction
    @LiteralParameters(value={"x"})
    public static void input(@AggregationState KHyperLogLogState state, @SqlType(value="double") double value, @SqlType(value="varchar(x)") Slice uii) {
        KHyperLogLogAggregationFunction.input(state, Double.doubleToLongBits(value), XxHash64.hash((Slice)uii));
    }

    @CombineFunction
    public static void combine(@AggregationState KHyperLogLogState state, @AggregationState KHyperLogLogState otherState) {
        if (state.getKHLL() == null) {
            KHyperLogLog copy = new KHyperLogLog();
            copy.mergeWith(otherState.getKHLL());
            state.setKHLL(copy);
        } else {
            state.getKHLL().mergeWith(otherState.getKHLL());
        }
    }

    @OutputFunction(value="KHyperLogLog")
    public static void output(@AggregationState KHyperLogLogState state, BlockBuilder out) {
        SERIALIZER.serialize(state, out);
    }
}

