/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type.khyperloglog;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.khyperloglog.KHyperLogLog;
import io.airlift.slice.Slice;
import java.util.Map;

public final class KHyperLogLogFunctions {
    private KHyperLogLogFunctions() {
    }

    @ScalarFunction
    @SqlType(value="bigint")
    public static long cardinality(@SqlType(value="KHyperLogLog") Slice khll) {
        return KHyperLogLog.newInstance(khll).cardinality();
    }

    @ScalarFunction
    @SqlType(value="bigint")
    public static long intersectionCardinality(@SqlType(value="KHyperLogLog") Slice slice1, @SqlType(value="KHyperLogLog") Slice slice2) {
        KHyperLogLog khll1 = KHyperLogLog.newInstance(slice1);
        KHyperLogLog khll2 = KHyperLogLog.newInstance(slice2);
        if (khll1.isExact() && khll2.isExact()) {
            return KHyperLogLog.exactIntersectionCardinality(khll1, khll2);
        }
        long lowestCardinality = Math.min(khll1.cardinality(), khll2.cardinality());
        double jaccard = KHyperLogLog.jaccardIndex(khll1, khll2);
        KHyperLogLog setUnion = KHyperLogLog.merge(khll1, khll2);
        long result = Math.round(jaccard * (double)setUnion.cardinality());
        return Math.min(result, lowestCardinality);
    }

    @ScalarFunction
    @SqlType(value="double")
    public static double jaccardIndex(@SqlType(value="KHyperLogLog") Slice slice1, @SqlType(value="KHyperLogLog") Slice slice2) {
        KHyperLogLog khll1 = KHyperLogLog.newInstance(slice1);
        KHyperLogLog khll2 = KHyperLogLog.newInstance(slice2);
        return KHyperLogLog.jaccardIndex(khll1, khll2);
    }

    @ScalarFunction
    @SqlType(value="map(bigint,double)")
    public static Block uniquenessDistribution(@TypeParameter(value="map<bigint,double>") Type mapType, @SqlType(value="KHyperLogLog") Slice slice) {
        KHyperLogLog khll = KHyperLogLog.newInstance(slice);
        return KHyperLogLogFunctions.uniquenessDistribution(mapType, slice, khll.getMinhashSize());
    }

    @ScalarFunction
    @SqlType(value="map(bigint,double)")
    public static Block uniquenessDistribution(@TypeParameter(value="map<bigint,double>") Type mapType, @SqlType(value="KHyperLogLog") Slice slice, @SqlType(value="bigint") long histogramSize) {
        KHyperLogLog khll = KHyperLogLog.newInstance(slice);
        BlockBuilder blockBuilder = mapType.createBlockBuilder(null, 1);
        BlockBuilder singleMapBlockBuilder = blockBuilder.beginBlockEntry();
        for (Map.Entry entry : khll.uniquenessDistribution(histogramSize).entrySet()) {
            BigintType.BIGINT.writeLong(singleMapBlockBuilder, ((Long)entry.getKey()).longValue());
            DoubleType.DOUBLE.writeDouble(singleMapBlockBuilder, ((Double)entry.getValue()).doubleValue());
        }
        blockBuilder.closeEntry();
        return (Block)mapType.getObject((Block)blockBuilder, 0);
    }

    @ScalarFunction
    @SqlType(value="double")
    public static double reidentificationPotential(@SqlType(value="KHyperLogLog") Slice khll, @SqlType(value="bigint") long threshold) {
        return KHyperLogLog.newInstance(khll).reidentificationPotential(threshold);
    }

    @ScalarFunction
    @SqlType(value="KHyperLogLog")
    @SqlNullable
    public static Slice mergeKhll(@SqlType(value="array(KHyperLogLog)") Block block) {
        int firstNonNullIndex;
        if (block.getPositionCount() == 0) {
            return null;
        }
        KHyperLogLog merged = null;
        for (firstNonNullIndex = 0; firstNonNullIndex < block.getPositionCount() && block.isNull(firstNonNullIndex); ++firstNonNullIndex) {
        }
        if (firstNonNullIndex == block.getPositionCount()) {
            return null;
        }
        Slice initialSlice = block.getSlice(firstNonNullIndex, 0, block.getSliceLength(firstNonNullIndex));
        merged = KHyperLogLog.newInstance(initialSlice);
        for (int i = firstNonNullIndex; i < block.getPositionCount(); ++i) {
            Slice currentSlice = block.getSlice(i, 0, block.getSliceLength(i));
            if (block.isNull(i)) continue;
            merged = KHyperLogLog.merge(merged, KHyperLogLog.newInstance(currentSlice));
        }
        return merged.serialize();
    }
}

