/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type.khyperloglog;

import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.type.khyperloglog.KHyperLogLog;
import com.facebook.presto.type.khyperloglog.KHyperLogLogState;
import com.facebook.presto.type.khyperloglog.KHyperLogLogType;
import io.airlift.slice.Slice;

@AggregationFunction(value="merge")
public final class MergeKHyperLogLogAggregationFunction {
    private MergeKHyperLogLogAggregationFunction() {
    }

    @InputFunction
    public static void input(@AggregationState KHyperLogLogState state, @SqlType(value="KHyperLogLog") Slice value) {
        KHyperLogLog instance = KHyperLogLog.newInstance(value);
        MergeKHyperLogLogAggregationFunction.merge(state, instance);
    }

    @CombineFunction
    public static void combine(@AggregationState KHyperLogLogState state, @AggregationState KHyperLogLogState otherState) {
        MergeKHyperLogLogAggregationFunction.merge(state, otherState.getKHLL());
    }

    private static void merge(@AggregationState KHyperLogLogState state, KHyperLogLog instance) {
        if (state.getKHLL() == null) {
            state.setKHLL(instance);
        } else {
            state.getKHLL().mergeWith(instance);
        }
    }

    @OutputFunction(value="KHyperLogLog")
    public static void output(@AggregationState KHyperLogLogState state, BlockBuilder out) {
        if (state.getKHLL() == null) {
            out.appendNull();
        } else {
            KHyperLogLogType.K_HYPER_LOG_LOG.writeSlice(out, state.getKHLL().serialize());
        }
    }
}

