/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpcds;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.tpcds.TpcdsColumnHandle;
import com.facebook.presto.tpcds.TpcdsTableHandle;
import com.facebook.presto.tpcds.TpcdsTableLayoutHandle;
import com.facebook.presto.tpcds.statistics.TpcdsTableStatisticsFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.teradata.tpcds.Table;
import com.teradata.tpcds.column.Column;
import com.teradata.tpcds.column.ColumnType;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TpcdsMetadata
implements ConnectorMetadata {
    public static final String TINY_SCHEMA_NAME = "tiny";
    public static final double TINY_SCALE_FACTOR = 0.01;
    public static final List<String> SCHEMA_NAMES = ImmutableList.of((Object)"tiny", (Object)"sf1", (Object)"sf10", (Object)"sf100", (Object)"sf300", (Object)"sf1000", (Object)"sf3000", (Object)"sf10000", (Object)"sf30000", (Object)"sf100000");
    private final Set<String> tableNames;
    private final TpcdsTableStatisticsFactory tpcdsTableStatisticsFactory = new TpcdsTableStatisticsFactory();

    public TpcdsMetadata() {
        ImmutableSet.Builder tableNames = ImmutableSet.builder();
        for (Table tpcdsTable : Table.getBaseTables()) {
            tableNames.add((Object)tpcdsTable.getName().toLowerCase(Locale.ENGLISH));
        }
        this.tableNames = tableNames.build();
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return SCHEMA_NAMES;
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (!this.tableNames.contains(tableName.getTableName())) {
            return null;
        }
        double scaleFactor = TpcdsMetadata.schemaNameToScaleFactor(tableName.getSchemaName());
        if (scaleFactor <= 0.0) {
            return null;
        }
        return new TpcdsTableHandle(tableName.getTableName(), scaleFactor);
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        TpcdsTableHandle tableHandle = (TpcdsTableHandle)table;
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new TpcdsTableLayoutHandle(tableHandle), Optional.empty(), TupleDomain.all(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of());
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        TpcdsTableLayoutHandle layout = (TpcdsTableLayoutHandle)handle;
        return this.getTableLayouts(session, layout.getTable(), (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.empty()).get(0).getTableLayout();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        TpcdsTableHandle tpcdsTableHandle = (TpcdsTableHandle)tableHandle;
        Table table = Table.getTable((String)tpcdsTableHandle.getTableName());
        String schemaName = TpcdsMetadata.scaleFactorSchemaName(tpcdsTableHandle.getScaleFactor());
        return TpcdsMetadata.getTableMetadata(schemaName, table);
    }

    private static ConnectorTableMetadata getTableMetadata(String schemaName, Table tpcdsTable) {
        ImmutableList.Builder columns = ImmutableList.builder();
        for (Column column : tpcdsTable.getColumns()) {
            columns.add((Object)new ColumnMetadata(column.getName(), TpcdsMetadata.getPrestoType(column.getType())));
        }
        SchemaTableName tableName = new SchemaTableName(schemaName, tpcdsTable.getName());
        return new ConnectorTableMetadata(tableName, (List)columns.build());
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<ConnectorTableLayoutHandle> tableLayoutHandle, List<ColumnHandle> columnHandles, Constraint<ColumnHandle> constraint) {
        TpcdsTableHandle tpcdsTableHandle = (TpcdsTableHandle)tableHandle;
        Table table = Table.getTable((String)tpcdsTableHandle.getTableName());
        String schemaName = TpcdsMetadata.scaleFactorSchemaName(tpcdsTableHandle.getScaleFactor());
        return this.tpcdsTableStatisticsFactory.create(schemaName, table, columnHandles);
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ColumnMetadata columnMetadata : this.getTableMetadata(session, tableHandle).getColumns()) {
            builder.put((Object)columnMetadata.getName(), (Object)new TpcdsColumnHandle(columnMetadata.getName(), columnMetadata.getType()));
        }
        return builder.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, tableHandle);
        String columnName = ((TpcdsColumnHandle)columnHandle).getColumnName();
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            if (!column.getName().equals(columnName)) continue;
            return column;
        }
        throw new IllegalArgumentException(String.format("Table %s does not have column %s", tableMetadata.getTable(), columnName));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder tableColumns = ImmutableMap.builder();
        for (String schemaName : this.getSchemaNames(session, Optional.ofNullable(prefix.getSchemaName()))) {
            for (Table tpcdsTable : Table.getBaseTables()) {
                if (prefix.getTableName() != null && !tpcdsTable.getName().equals(prefix.getTableName())) continue;
                ConnectorTableMetadata tableMetadata = TpcdsMetadata.getTableMetadata(schemaName, tpcdsTable);
                tableColumns.put((Object)new SchemaTableName(schemaName, tpcdsTable.getName()), (Object)tableMetadata.getColumns());
            }
        }
        return tableColumns.build();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> filterSchema) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String schemaName : this.getSchemaNames(session, filterSchema)) {
            for (Table tpcdsTable : Table.getBaseTables()) {
                builder.add((Object)new SchemaTableName(schemaName, tpcdsTable.getName()));
            }
        }
        return builder.build();
    }

    private List<String> getSchemaNames(ConnectorSession session, Optional<String> schemaName) {
        if (!schemaName.isPresent()) {
            return this.listSchemaNames(session);
        }
        if (TpcdsMetadata.schemaNameToScaleFactor(schemaName.get()) > 0.0) {
            return ImmutableList.of((Object)schemaName.get());
        }
        return ImmutableList.of();
    }

    private static String scaleFactorSchemaName(double scaleFactor) {
        return "sf" + scaleFactor;
    }

    public static double schemaNameToScaleFactor(String schemaName) {
        if (TINY_SCHEMA_NAME.equals(schemaName)) {
            return 0.01;
        }
        if (!schemaName.startsWith("sf")) {
            return -1.0;
        }
        try {
            return Double.parseDouble(schemaName.substring(2));
        }
        catch (Exception ignored) {
            return -1.0;
        }
    }

    public static Type getPrestoType(ColumnType tpcdsType) {
        switch (tpcdsType.getBase()) {
            case IDENTIFIER: {
                return BigintType.BIGINT;
            }
            case INTEGER: {
                return IntegerType.INTEGER;
            }
            case DATE: {
                return DateType.DATE;
            }
            case DECIMAL: {
                return DecimalType.createDecimalType((int)((Integer)tpcdsType.getPrecision().get()), (int)((Integer)tpcdsType.getScale().get()));
            }
            case CHAR: {
                return CharType.createCharType((long)((Integer)tpcdsType.getPrecision().get()).intValue());
            }
            case VARCHAR: {
                return VarcharType.createVarcharType((int)((Integer)tpcdsType.getPrecision().get()));
            }
            case TIME: {
                return TimeType.TIME;
            }
        }
        throw new IllegalArgumentException("Unsupported TPC-DS type " + tpcdsType);
    }
}

