/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpcds.statistics;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.statistics.ColumnStatistics;
import com.facebook.presto.spi.statistics.DoubleRange;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.tpcds.TpcdsColumnHandle;
import com.facebook.presto.tpcds.statistics.ColumnStatisticsData;
import com.facebook.presto.tpcds.statistics.TableStatisticsData;
import com.facebook.presto.tpcds.statistics.TableStatisticsDataRepository;
import com.teradata.tpcds.Table;
import io.airlift.slice.Slice;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TpcdsTableStatisticsFactory {
    private final TableStatisticsDataRepository statisticsDataRepository = new TableStatisticsDataRepository();

    public TableStatistics create(String schemaName, Table table, List<ColumnHandle> columnHandles) {
        Optional<TableStatisticsData> statisticsDataOptional = this.statisticsDataRepository.load(schemaName, table);
        return statisticsDataOptional.map(statisticsData -> this.toTableStatistics(columnHandles, (TableStatisticsData)statisticsData)).orElse(TableStatistics.empty());
    }

    private TableStatistics toTableStatistics(List<ColumnHandle> columnHandles, TableStatisticsData statisticsData) {
        long rowCount = statisticsData.getRowCount();
        TableStatistics.Builder tableStatistics = TableStatistics.builder().setRowCount(Estimate.of((double)rowCount));
        if (rowCount > 0L) {
            Map<String, ColumnStatisticsData> columnsData = statisticsData.getColumns();
            for (ColumnHandle handle : columnHandles) {
                TpcdsColumnHandle columnHandle = (TpcdsColumnHandle)handle;
                tableStatistics.setColumnStatistics((ColumnHandle)columnHandle, this.toColumnStatistics(columnsData.get(columnHandle.getColumnName()), columnHandle.getType(), rowCount));
            }
        }
        return tableStatistics.build();
    }

    private ColumnStatistics toColumnStatistics(ColumnStatisticsData columnStatisticsData, Type type, long rowCount) {
        ColumnStatistics.Builder columnStatistics = ColumnStatistics.builder();
        long nullCount = columnStatisticsData.getNullsCount();
        columnStatistics.setNullsFraction(Estimate.of((double)((double)nullCount / (double)rowCount)));
        columnStatistics.setRange(TpcdsTableStatisticsFactory.toRange(columnStatisticsData.getMin(), columnStatisticsData.getMax(), type));
        columnStatistics.setDistinctValuesCount(Estimate.of((double)columnStatisticsData.getDistinctValuesCount()));
        columnStatistics.setDataSize(columnStatisticsData.getDataSize().map(Estimate::of).orElse(Estimate.unknown()));
        return columnStatistics.build();
    }

    private static Optional<DoubleRange> toRange(Optional<Object> min, Optional<Object> max, Type columnType) {
        if (columnType instanceof VarcharType || columnType instanceof CharType || columnType.equals(TimeType.TIME)) {
            return Optional.empty();
        }
        if (!min.isPresent() || !max.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new DoubleRange(TpcdsTableStatisticsFactory.toDouble(min.get(), columnType), TpcdsTableStatisticsFactory.toDouble(max.get(), columnType)));
    }

    private static double toDouble(Object value, Type type) {
        if (value instanceof String && type.equals(DateType.DATE)) {
            return LocalDate.parse((CharSequence)value).toEpochDay();
        }
        if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(DateType.DATE)) {
            return ((Number)value).doubleValue();
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (Decimals.isShortDecimal((Type)decimalType)) {
                return Double.parseDouble(Decimals.toString((long)((Number)value).longValue(), (int)decimalType.getScale()));
            }
            if (Decimals.isLongDecimal((Type)decimalType)) {
                return Double.parseDouble(Decimals.toString((Slice)((Slice)value), (int)decimalType.getScale()));
            }
            throw new IllegalArgumentException("Unexpected decimal type: " + decimalType);
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return ((Number)value).doubleValue();
        }
        throw new IllegalArgumentException("unsupported column type " + type);
    }
}

