/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import java.util.LinkedList;
import java.util.List;

public class TimeSeries {
    private final String mName;
    private final List<DataPoint> mDataPoints;

    public TimeSeries(String name) {
        this.mName = name;
        this.mDataPoints = new LinkedList<DataPoint>();
    }

    public void record(double value) {
        this.mDataPoints.add(new DataPoint(value));
    }

    public String getName() {
        return this.mName;
    }

    public List<DataPoint> getDataPoints() {
        return this.mDataPoints;
    }

    public final class DataPoint {
        private final long mTimestamp = System.currentTimeMillis();
        private final double mValue;

        public DataPoint(double value) {
            this.mValue = value;
        }

        public long getTimeStamp() {
            return this.mTimestamp;
        }

        public double getValue() {
            return this.mValue;
        }
    }
}

