/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.exception.status.UnauthenticatedException;
import alluxio.grpc.SaslMessage;
import alluxio.grpc.SaslMessageType;
import alluxio.security.authentication.SaslHandshakeServerHandler;
import alluxio.security.authentication.SaslServerHandler;
import alluxio.shaded.client.com.google.protobuf.ByteString;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

public class DefaultSaslHandshakeServerHandler
implements SaslHandshakeServerHandler {
    private final SaslServerHandler mSaslServerHandler;
    private final SaslServer mSaslServer;

    public DefaultSaslHandshakeServerHandler(SaslServerHandler saslServerHandler) throws UnauthenticatedException {
        this.mSaslServerHandler = saslServerHandler;
        this.mSaslServer = this.mSaslServerHandler.getSaslServer();
    }

    @Override
    public SaslMessage handleSaslMessage(SaslMessage message) throws SaslException {
        switch (message.getMessageType()) {
            case CHALLENGE: {
                byte[] saslResponse = this.mSaslServer.evaluateResponse(message.getMessage().toByteArray());
                SaslMessage.Builder response = SaslMessage.newBuilder();
                if (this.mSaslServer.isComplete()) {
                    response.setMessageType(SaslMessageType.SUCCESS);
                } else {
                    response.setMessageType(SaslMessageType.CHALLENGE);
                }
                if (saslResponse != null) {
                    response.setMessage(ByteString.copyFrom(saslResponse));
                }
                return response.build();
            }
        }
        throw new SaslException("Server can't process Sasl message type:" + message.getMessageType().name());
    }
}

