/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.exception.status.UnauthenticatedException;
import alluxio.grpc.SaslMessage;
import alluxio.grpc.SaslMessageType;
import alluxio.security.authentication.AuthenticationServer;
import alluxio.security.authentication.DefaultSaslHandshakeServerHandler;
import alluxio.security.authentication.SaslHandshakeServerHandler;
import alluxio.security.authentication.SaslServerHandler;
import alluxio.shaded.client.io.grpc.stub.StreamObserver;
import alluxio.util.LogUtils;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.sasl.SaslException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslStreamServerDriver
implements StreamObserver<SaslMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(SaslStreamServerDriver.class);
    private static final UUID EMPTY_UUID = new UUID(0L, 0L);
    private StreamObserver<SaslMessage> mRequestObserver = null;
    private SaslHandshakeServerHandler mSaslHandshakeServerHandler;
    private AuthenticationServer mAuthenticationServer;
    private UUID mChannelId = EMPTY_UUID;
    private SaslServerHandler mSaslServerHandler = null;
    private AtomicBoolean mClientStreamValid = new AtomicBoolean(true);

    public SaslStreamServerDriver(AuthenticationServer authenticationServer) {
        this.mAuthenticationServer = authenticationServer;
    }

    public void setClientObserver(StreamObserver<SaslMessage> requestObserver) {
        this.mRequestObserver = requestObserver;
    }

    @Override
    public void onNext(SaslMessage saslMessage) {
        boolean closeHandler = false;
        try {
            if (this.mSaslHandshakeServerHandler == null) {
                LOG.debug("SaslServerDriver received authentication request of type:{} from channel: {}", (Object)saslMessage.getAuthenticationScheme(), (Object)saslMessage.getClientId());
                this.mChannelId = UUID.fromString(saslMessage.getClientId());
                this.mSaslServerHandler = this.mAuthenticationServer.createSaslHandler(saslMessage.getAuthenticationScheme());
                this.mSaslHandshakeServerHandler = new DefaultSaslHandshakeServerHandler(this.mSaslServerHandler);
                this.mAuthenticationServer.unregisterChannel(this.mChannelId);
            }
            LOG.debug("SaslServerDriver received message: {} from channel: {}", (Object)saslMessage, (Object)this.mChannelId);
            SaslMessage response = this.mSaslHandshakeServerHandler.handleSaslMessage(saslMessage);
            if (response.getMessageType() == SaslMessageType.SUCCESS) {
                this.mAuthenticationServer.registerChannel(this.mChannelId, this.mSaslServerHandler.getAuthenticatedUserInfo(), this);
                closeHandler = true;
            }
            this.mRequestObserver.onNext(response);
        }
        catch (SaslException se) {
            LOG.debug("Exception while handling SASL message: {} for channel: {}. Error: {}", new Object[]{saslMessage, this.mChannelId, se});
            this.mRequestObserver.onError(new UnauthenticatedException(se).toGrpcStatusException());
            closeHandler = true;
        }
        catch (UnauthenticatedException ue) {
            LOG.debug("Exception while handling SASL message: {} for channel: {}. Error: {}", new Object[]{saslMessage, this.mChannelId, ue});
            this.mRequestObserver.onError(ue.toGrpcStatusException());
            closeHandler = true;
        }
        catch (Exception e) {
            LOG.debug("Exception while handling SASL message: {} for channel: {}. Error: {}", new Object[]{saslMessage, this.mChannelId, e});
            closeHandler = true;
            throw e;
        }
        finally {
            if (closeHandler) {
                try {
                    this.mSaslServerHandler.close();
                }
                catch (IOException exc) {
                    LOG.debug("Failed to close SaslServer.", (Throwable)exc);
                }
            }
        }
    }

    @Override
    public void onError(Throwable throwable) {
        LOG.warn("Error received for channel: {}. Error: {}", (Object)this.mChannelId, (Object)throwable);
        this.mClientStreamValid.set(false);
        if (!this.mChannelId.equals(EMPTY_UUID)) {
            LOG.debug("Closing authenticated channel: {} due to error: {}", (Object)this.mChannelId, (Object)throwable);
            if (!this.mAuthenticationServer.unregisterChannel(this.mChannelId)) {
                this.close();
            }
        }
    }

    @Override
    public void onCompleted() {
        LOG.debug("Received completion for authenticated channel: {}", (Object)this.mChannelId);
        if (!this.mAuthenticationServer.unregisterChannel(this.mChannelId)) {
            this.close();
        }
    }

    public void close() {
        LOG.debug("Closing server driver for channel: {}", (Object)this.mChannelId);
        this.completeStreamQuietly();
        if (this.mSaslServerHandler != null) {
            try {
                this.mSaslServerHandler.close();
            }
            catch (Exception exc) {
                LogUtils.warnWithException(LOG, "Failed to close server driver for channel: {}.", this.mChannelId, exc);
            }
        }
    }

    private void completeStreamQuietly() {
        if (this.mClientStreamValid.get() && this.mRequestObserver != null) {
            try {
                this.mRequestObserver.onCompleted();
            }
            catch (Exception exc) {
                LOG.debug("Failed to close authentication stream for channel: {}. Error: {}", (Object)this.mChannelId, (Object)exc);
            }
            finally {
                this.mClientStreamValid.set(false);
            }
        }
    }
}

