/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift.api;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.connector.thrift.api.valuesets.PrestoThriftValueSet;
import com.facebook.presto.spi.predicate.Domain;
import com.google.common.base.MoreObjects;
import java.util.Objects;

@ThriftStruct
public final class PrestoThriftDomain {
    private final PrestoThriftValueSet valueSet;
    private final boolean nullAllowed;

    @ThriftConstructor
    public PrestoThriftDomain(PrestoThriftValueSet valueSet, boolean nullAllowed) {
        this.valueSet = Objects.requireNonNull(valueSet, "valueSet is null");
        this.nullAllowed = nullAllowed;
    }

    @ThriftField(value=1)
    public PrestoThriftValueSet getValueSet() {
        return this.valueSet;
    }

    @ThriftField(value=2)
    public boolean isNullAllowed() {
        return this.nullAllowed;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoThriftDomain other = (PrestoThriftDomain)obj;
        return Objects.equals(this.valueSet, other.valueSet) && this.nullAllowed == other.nullAllowed;
    }

    public int hashCode() {
        return Objects.hash(this.valueSet, this.nullAllowed);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("valueSet", (Object)this.valueSet).add("nullAllowed", this.nullAllowed).toString();
    }

    public static PrestoThriftDomain fromDomain(Domain domain) {
        return new PrestoThriftDomain(PrestoThriftValueSet.fromValueSet(domain.getValues()), domain.isNullAllowed());
    }
}

