/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift.api.valuesets;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftEnum;
import com.facebook.drift.annotations.ThriftEnumValue;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.connector.thrift.api.PrestoThriftBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.predicate.Marker;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.SortedRangeSet;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ThriftStruct
public final class PrestoThriftRangeValueSet {
    private final List<PrestoThriftRange> ranges;

    @ThriftConstructor
    public PrestoThriftRangeValueSet(@ThriftField(name="ranges") List<PrestoThriftRange> ranges) {
        this.ranges = Objects.requireNonNull(ranges, "ranges is null");
    }

    @ThriftField(value=1)
    public List<PrestoThriftRange> getRanges() {
        return this.ranges;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoThriftRangeValueSet other = (PrestoThriftRangeValueSet)obj;
        return Objects.equals(this.ranges, other.ranges);
    }

    public int hashCode() {
        return Objects.hashCode(this.ranges);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRanges", this.ranges.size()).toString();
    }

    public static PrestoThriftRangeValueSet fromSortedRangeSet(SortedRangeSet valueSet) {
        List ranges = (List)valueSet.getOrderedRanges().stream().map(PrestoThriftRange::fromRange).collect(ImmutableList.toImmutableList());
        return new PrestoThriftRangeValueSet(ranges);
    }

    @ThriftStruct
    public static final class PrestoThriftRange {
        private final PrestoThriftMarker low;
        private final PrestoThriftMarker high;

        @ThriftConstructor
        public PrestoThriftRange(PrestoThriftMarker low, PrestoThriftMarker high) {
            this.low = Objects.requireNonNull(low, "low is null");
            this.high = Objects.requireNonNull(high, "high is null");
        }

        @ThriftField(value=1)
        public PrestoThriftMarker getLow() {
            return this.low;
        }

        @ThriftField(value=2)
        public PrestoThriftMarker getHigh() {
            return this.high;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PrestoThriftRange other = (PrestoThriftRange)obj;
            return Objects.equals(this.low, other.low) && Objects.equals(this.high, other.high);
        }

        public int hashCode() {
            return Objects.hash(this.low, this.high);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("low", (Object)this.low).add("high", (Object)this.high).toString();
        }

        public static PrestoThriftRange fromRange(Range range) {
            return new PrestoThriftRange(PrestoThriftMarker.fromMarker(range.getLow()), PrestoThriftMarker.fromMarker(range.getHigh()));
        }
    }

    @ThriftStruct
    public static final class PrestoThriftMarker {
        private final PrestoThriftBlock value;
        private final PrestoThriftBound bound;

        @ThriftConstructor
        public PrestoThriftMarker(@Nullable PrestoThriftBlock value, PrestoThriftBound bound) {
            Preconditions.checkArgument((value == null || value.numberOfRecords() == 1 ? 1 : 0) != 0, (Object)"value must contain exactly one record when present");
            this.value = value;
            this.bound = Objects.requireNonNull(bound, "bound is null");
        }

        @Nullable
        @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
        public PrestoThriftBlock getValue() {
            return this.value;
        }

        @ThriftField(value=2)
        public PrestoThriftBound getBound() {
            return this.bound;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PrestoThriftMarker other = (PrestoThriftMarker)obj;
            return Objects.equals(this.value, other.value) && Objects.equals((Object)this.bound, (Object)other.bound);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.value, this.bound});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).add("bound", (Object)this.bound).toString();
        }

        public static PrestoThriftMarker fromMarker(Marker marker) {
            PrestoThriftBlock value = marker.getValueBlock().isPresent() ? PrestoThriftBlock.fromBlock((Block)marker.getValueBlock().get(), marker.getType()) : null;
            return new PrestoThriftMarker(value, PrestoThriftBound.fromBound(marker.getBound()));
        }
    }

    @ThriftEnum
    public static enum PrestoThriftBound {
        BELOW(1),
        EXACTLY(2),
        ABOVE(3);

        private final int value;

        private PrestoThriftBound(int value) {
            this.value = value;
        }

        @ThriftEnumValue
        public int getValue() {
            return this.value;
        }

        public static PrestoThriftBound fromBound(Marker.Bound bound) {
            switch (bound) {
                case BELOW: {
                    return BELOW;
                }
                case EXACTLY: {
                    return EXACTLY;
                }
                case ABOVE: {
                    return ABOVE;
                }
            }
            throw new IllegalArgumentException("Unknown bound: " + bound);
        }
    }
}

