/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.event.QueryMonitor;
import com.facebook.presto.execution.QueryIdGenerator;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryPreparer;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.warnings.WarningCollector;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.server.QuerySessionSupplier;
import com.facebook.presto.server.SessionContext;
import com.facebook.presto.spark.PrestoSparkAuthenticatorProvider;
import com.facebook.presto.spark.PrestoSparkCredentialsProvider;
import com.facebook.presto.spark.PrestoSparkSessionContext;
import com.facebook.presto.spark.PrestoSparkTaskDescriptor;
import com.facebook.presto.spark.classloader_interface.IPrestoSparkQueryExecution;
import com.facebook.presto.spark.classloader_interface.IPrestoSparkQueryExecutionFactory;
import com.facebook.presto.spark.classloader_interface.PrestoSparkRow;
import com.facebook.presto.spark.classloader_interface.PrestoSparkSession;
import com.facebook.presto.spark.classloader_interface.PrestoSparkTaskExecutorFactoryProvider;
import com.facebook.presto.spark.classloader_interface.PrestoSparkTaskInputs;
import com.facebook.presto.spark.classloader_interface.SerializedPrestoSparkTaskDescriptor;
import com.facebook.presto.spark.classloader_interface.SerializedTaskStats;
import com.facebook.presto.spark.planner.PrestoSparkPlan;
import com.facebook.presto.spark.planner.PrestoSparkPlanFragmenter;
import com.facebook.presto.spark.planner.PrestoSparkQueryPlanner;
import com.facebook.presto.spark.planner.PrestoSparkRddFactory;
import com.facebook.presto.spark.planner.PrestoSparkSplitEnumerator;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.planPrinter.PlanPrinter;
import com.facebook.presto.transaction.TransactionId;
import com.facebook.presto.transaction.TransactionInfo;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.Slices;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import javax.inject.Inject;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.util.CollectionAccumulator;
import scala.Option;
import scala.Some;
import scala.Tuple2;

public class PrestoSparkQueryExecutionFactory
implements IPrestoSparkQueryExecutionFactory {
    private static final Logger log = Logger.get(PrestoSparkQueryExecutionFactory.class);
    private final QueryIdGenerator queryIdGenerator;
    private final QuerySessionSupplier sessionSupplier;
    private final QueryPreparer queryPreparer;
    private final PrestoSparkQueryPlanner queryPlanner;
    private final PrestoSparkPlanFragmenter planFragmenter;
    private final PrestoSparkSplitEnumerator splitEnumerator;
    private final PrestoSparkRddFactory rddFactory;
    private final QueryMonitor queryMonitor;
    private final JsonCodec<TaskStats> taskStatsJsonCodec;
    private final JsonCodec<PrestoSparkTaskDescriptor> sparkTaskDescriptorJsonCodec;
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final Metadata metadata;
    private final Set<PrestoSparkCredentialsProvider> credentialsProviders;
    private final Set<PrestoSparkAuthenticatorProvider> authenticatorProviders;

    @Inject
    public PrestoSparkQueryExecutionFactory(QueryIdGenerator queryIdGenerator, QuerySessionSupplier sessionSupplier, QueryPreparer queryPreparer, PrestoSparkQueryPlanner queryPlanner, PrestoSparkPlanFragmenter planFragmenter, PrestoSparkSplitEnumerator splitEnumerator, PrestoSparkRddFactory rddFactory, QueryMonitor queryMonitor, JsonCodec<TaskStats> taskStatsJsonCodec, JsonCodec<PrestoSparkTaskDescriptor> sparkTaskDescriptorJsonCodec, TransactionManager transactionManager, AccessControl accessControl, Metadata metadata, Set<PrestoSparkCredentialsProvider> credentialsProviders, Set<PrestoSparkAuthenticatorProvider> authenticatorProviders) {
        this.queryIdGenerator = Objects.requireNonNull(queryIdGenerator, "queryIdGenerator is null");
        this.sessionSupplier = Objects.requireNonNull(sessionSupplier, "sessionSupplier is null");
        this.queryPreparer = Objects.requireNonNull(queryPreparer, "queryPreparer is null");
        this.queryPlanner = Objects.requireNonNull(queryPlanner, "queryPlanner is null");
        this.planFragmenter = Objects.requireNonNull(planFragmenter, "planFragmenter is null");
        this.splitEnumerator = Objects.requireNonNull(splitEnumerator, "splitEnumerator is null");
        this.rddFactory = Objects.requireNonNull(rddFactory, "rddFactory is null");
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        this.taskStatsJsonCodec = Objects.requireNonNull(taskStatsJsonCodec, "taskStatsJsonCodec is null");
        this.sparkTaskDescriptorJsonCodec = Objects.requireNonNull(sparkTaskDescriptorJsonCodec, "sparkTaskDescriptorJsonCodec is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.credentialsProviders = ImmutableSet.copyOf((Collection)Objects.requireNonNull(credentialsProviders, "credentialsProviders is null"));
        this.authenticatorProviders = ImmutableSet.copyOf((Collection)Objects.requireNonNull(authenticatorProviders, "authenticatorProviders is null"));
    }

    public IPrestoSparkQueryExecution create(SparkContext sparkContext, PrestoSparkSession prestoSparkSession, String sql, PrestoSparkTaskExecutorFactoryProvider executorFactoryProvider) {
        QueryId queryId = this.queryIdGenerator.createNextQueryId();
        PrestoSparkSessionContext sessionContext = PrestoSparkSessionContext.createFromSessionInfo(prestoSparkSession, this.credentialsProviders, this.authenticatorProviders);
        TransactionId transactionId = this.transactionManager.beginTransaction(true);
        Session session = this.sessionSupplier.createSession(queryId, (SessionContext)sessionContext).beginTransactionId(transactionId, this.transactionManager, this.accessControl);
        WarningCollector warningCollector = WarningCollector.NOOP;
        QueryPreparer.PreparedQuery preparedQuery = this.queryPreparer.prepareQuery(session, sql, warningCollector);
        PrestoSparkQueryPlanner.PlanAndUpdateType planAndUpdateType = this.queryPlanner.createQueryPlan(session, preparedQuery, warningCollector);
        SubPlan fragmentedPlan = this.planFragmenter.fragmentQueryPlan(session, planAndUpdateType.getPlan(), warningCollector);
        log.info(PlanPrinter.textDistributedPlan((SubPlan)fragmentedPlan, (FunctionManager)this.metadata.getFunctionManager(), (Session)session, (boolean)true));
        PrestoSparkPlan prestoSparkPlan = this.splitEnumerator.preparePlan(session, fragmentedPlan);
        JavaSparkContext javaSparkContext = new JavaSparkContext(sparkContext);
        CollectionAccumulator taskStatsCollector = new CollectionAccumulator();
        taskStatsCollector.register(sparkContext, (Option)new Some((Object)"taskStatsCollector"), false);
        JavaPairRDD<Integer, PrestoSparkRow> rdd = this.rddFactory.createSparkRdd(javaSparkContext, session, prestoSparkPlan, executorFactoryProvider, (CollectionAccumulator<SerializedTaskStats>)taskStatsCollector);
        return new PrestoSparkQueryExecution(session, this.queryMonitor, taskStatsCollector, rdd, executorFactoryProvider, prestoSparkPlan, planAndUpdateType.getUpdateType(), this.taskStatsJsonCodec, this.sparkTaskDescriptorJsonCodec, this.transactionManager);
    }

    public static class PrestoSparkQueryExecution
    implements IPrestoSparkQueryExecution {
        private final Session session;
        private final QueryMonitor queryMonitor;
        private final CollectionAccumulator<SerializedTaskStats> taskStatsCollector;
        private final JavaPairRDD<Integer, PrestoSparkRow> rdd;
        private final PrestoSparkTaskExecutorFactoryProvider prestoSparkTaskExecutorFactoryProvider;
        private final PrestoSparkPlan prestoSparkPlan;
        private final Optional<String> updateType;
        private final JsonCodec<TaskStats> taskStatsJsonCodec;
        private final JsonCodec<PrestoSparkTaskDescriptor> sparkTaskDescriptorJsonCodec;
        private final TransactionManager transactionManager;

        private PrestoSparkQueryExecution(Session session, QueryMonitor queryMonitor, CollectionAccumulator<SerializedTaskStats> taskStatsCollector, JavaPairRDD<Integer, PrestoSparkRow> rdd, PrestoSparkTaskExecutorFactoryProvider prestoSparkTaskExecutorFactoryProvider, PrestoSparkPlan prestoSparkPlan, Optional<String> updateType, JsonCodec<TaskStats> taskStatsJsonCodec, JsonCodec<PrestoSparkTaskDescriptor> sparkTaskDescriptorJsonCodec, TransactionManager transactionManager) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
            this.taskStatsCollector = Objects.requireNonNull(taskStatsCollector, "taskStatsCollector is null");
            this.rdd = Objects.requireNonNull(rdd, "rdd is null");
            this.prestoSparkTaskExecutorFactoryProvider = Objects.requireNonNull(prestoSparkTaskExecutorFactoryProvider, "prestoSparkExecutorFactoryProvider is null");
            this.prestoSparkPlan = Objects.requireNonNull(prestoSparkPlan, "prestoSparkPlan is null");
            this.updateType = updateType;
            this.taskStatsJsonCodec = Objects.requireNonNull(taskStatsJsonCodec, "taskStatsJsonCodec is null");
            this.sparkTaskDescriptorJsonCodec = Objects.requireNonNull(sparkTaskDescriptorJsonCodec, "sparkTaskDescriptorJsonCodec is null");
            this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        }

        public List<List<Object>> execute() {
            ImmutableList resultRdd;
            PlanFragment rootFragment = this.prestoSparkPlan.getPlan().getFragment();
            RemoteSourceNode remoteSource = (RemoteSourceNode)Iterables.getOnlyElement((Iterable)rootFragment.getRemoteSourceNodes());
            PrestoSparkTaskDescriptor taskDescriptor = new PrestoSparkTaskDescriptor(this.session.toSessionRepresentation(), this.session.getIdentity().getExtraCredentials(), rootFragment, (List<TaskSource>)ImmutableList.of(), this.prestoSparkPlan.getTableWriteInfo());
            SerializedPrestoSparkTaskDescriptor serializedTaskDescriptor = new SerializedPrestoSparkTaskDescriptor(this.sparkTaskDescriptorJsonCodec.toJsonBytes((Object)taskDescriptor));
            try {
                List sparkDriverInput = this.rdd.collect();
                resultRdd = ImmutableList.copyOf((Iterator)this.prestoSparkTaskExecutorFactoryProvider.get().create(0, 0, serializedTaskDescriptor, new PrestoSparkTaskInputs((Map)ImmutableMap.of((Object)remoteSource.getId().toString(), sparkDriverInput.iterator())), this.taskStatsCollector));
                this.commit();
            }
            catch (RuntimeException executionFailure) {
                block6: {
                    try {
                        this.rollback();
                    }
                    catch (RuntimeException rollbackFailure) {
                        if (executionFailure == rollbackFailure) break block6;
                        executionFailure.addSuppressed(rollbackFailure);
                    }
                }
                this.queryCompletedEvent(Optional.of(executionFailure));
                throw executionFailure;
            }
            this.queryCompletedEvent(Optional.empty());
            ConnectorSession connectorSession = this.session.toConnectorSession();
            List types = rootFragment.getTypes();
            ImmutableList.Builder result = ImmutableList.builder();
            for (Tuple2 tuple : resultRdd) {
                PrestoSparkRow row = (PrestoSparkRow)tuple._2;
                BasicSliceInput sliceInput = new BasicSliceInput(Slices.wrappedBuffer((byte[])row.getBytes(), (int)0, (int)row.getLength()));
                ImmutableList.Builder columns = ImmutableList.builder();
                for (Type type : types) {
                    BlockBuilder blockBuilder = type.createBlockBuilder(null, 1);
                    blockBuilder.readPositionFrom((SliceInput)sliceInput);
                    columns.add(type.getObjectValue(connectorSession, (Block)blockBuilder, 0));
                }
                result.add((Object)columns.build());
            }
            return result.build();
        }

        public List<Type> getOutputTypes() {
            return this.prestoSparkPlan.getPlan().getFragment().getTypes();
        }

        public Optional<String> getUpdateType() {
            return this.updateType;
        }

        private void commit() {
            MoreFutures.getFutureValue((Future)this.transactionManager.asyncCommit(this.getTransactionInfo().getTransactionId()));
        }

        private void rollback() {
            MoreFutures.getFutureValue((Future)this.transactionManager.asyncAbort(this.getTransactionInfo().getTransactionId()));
        }

        private TransactionInfo getTransactionInfo() {
            Optional transaction = this.session.getTransactionId().flatMap(arg_0 -> ((TransactionManager)this.transactionManager).getOptionalTransactionInfo(arg_0));
            Preconditions.checkState((boolean)transaction.isPresent(), (Object)"transaction is not present");
            Preconditions.checkState((boolean)((TransactionInfo)transaction.get()).isAutoCommitContext(), (Object)"transaction doesn't have auto commit context enabled");
            return (TransactionInfo)transaction.get();
        }

        private void queryCompletedEvent(Optional<Throwable> failure) {
        }

        private QueryInfo createQueryInfo(Optional<Throwable> failure) {
            List serializedTaskStats = this.taskStatsCollector.value();
            List taskStats = (List)serializedTaskStats.stream().map(SerializedTaskStats::getBytes).map(arg_0 -> this.taskStatsJsonCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
            return null;
        }
    }
}

