/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark;

import com.facebook.presto.Session;
import com.facebook.presto.spark.PrestoSparkConfig;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;

public class PrestoSparkSessionProperties {
    public static final String SPARK_INITIAL_PARTITION_COUNT = "spark_initial_partition_count";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public PrestoSparkSessionProperties(PrestoSparkConfig prestoSparkConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.integerProperty((String)SPARK_INITIAL_PARTITION_COUNT, (String)"Initial partition count for Spark RDD when reading table", (Integer)prestoSparkConfig.getInitialSparkPartitionCount(), (boolean)false));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static int getSparkInitialPartitionCount(Session session) {
        return (Integer)session.getSystemProperty(SPARK_INITIAL_PARTITION_COUNT, Integer.class);
    }
}

