/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.spark.classloader_interface.PrestoSparkRow;
import com.facebook.presto.spark.execution.PrestoSparkRowBuffer;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.OutputPartitioning;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SliceOutput;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;

public class PrestoSparkOutputOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final PrestoSparkRowBuffer rowBuffer;
    private final Function<Page, Page> pagePreprocessor;
    private final PartitionFunction partitionFunction;
    private final List<Integer> partitionChannels;
    private final List<Optional<Block>> partitionConstants;
    private final boolean replicateNullsAndAny;
    private final OptionalInt nullChannel;
    private boolean finished;
    private boolean hasAnyRowBeenReplicated;

    public PrestoSparkOutputOperator(OperatorContext operatorContext, PrestoSparkRowBuffer rowBuffer, Function<Page, Page> pagePreprocessor, PartitionFunction partitionFunction, List<Integer> partitionChannels, List<Optional<Block>> partitionConstants, boolean replicateNullsAndAny, OptionalInt nullChannel) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.rowBuffer = Objects.requireNonNull(rowBuffer, "rowBuffer is null");
        this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
        this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
        this.partitionChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionChannels, "partitionChannels is null"));
        this.partitionConstants = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionConstants, "partitionConstants is null"));
        this.replicateNullsAndAny = replicateNullsAndAny;
        this.nullChannel = Objects.requireNonNull(nullChannel, "nullChannel is null");
    }

    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    public ListenableFuture<?> isBlocked() {
        return this.rowBuffer.isFull();
    }

    public boolean needsInput() {
        return !this.finished && this.isBlocked().isDone();
    }

    public void addInput(Page page) {
        page = this.pagePreprocessor.apply(page);
        int positionCount = page.getPositionCount();
        int channelCount = page.getChannelCount();
        int averageRowSizeInBytes = Integer.min(Math.toIntExact(page.getLogicalSizeInBytes() / (long)positionCount), 10);
        Page partitionFunctionArguments = this.getPartitionFunctionArguments(page);
        for (int position = 0; position < positionCount; ++position) {
            boolean shouldReplicate;
            DynamicSliceOutput output = new DynamicSliceOutput(averageRowSizeInBytes * 2);
            for (int channel = 0; channel < channelCount; ++channel) {
                Block block = page.getBlock(channel);
                block.writePositionTo(position, (SliceOutput)output);
            }
            boolean bl = shouldReplicate = this.replicateNullsAndAny && !this.hasAnyRowBeenReplicated || this.nullChannel.isPresent() && page.getBlock(this.nullChannel.getAsInt()).isNull(position);
            if (shouldReplicate) {
                for (int i = 0; i < this.partitionFunction.getPartitionCount(); ++i) {
                    this.rowBuffer.enqueue(new PrestoSparkRow(i, output.size(), output.getUnderlyingSlice().byteArray()));
                }
                this.hasAnyRowBeenReplicated = true;
                continue;
            }
            int partition = this.getPartition(partitionFunctionArguments, position);
            this.rowBuffer.enqueue(new PrestoSparkRow(partition, output.size(), output.getUnderlyingSlice().byteArray()));
        }
    }

    private int getPartition(Page partitionFunctionArgs, int position) {
        return this.partitionFunction.getPartition(partitionFunctionArgs, position);
    }

    private Page getPartitionFunctionArguments(Page page) {
        Block[] blocks = new Block[this.partitionChannels.size()];
        for (int i = 0; i < blocks.length; ++i) {
            Optional<Block> partitionConstant = this.partitionConstants.get(i);
            blocks[i] = partitionConstant.isPresent() ? new RunLengthEncodedBlock(partitionConstant.get(), page.getPositionCount()) : page.getBlock(this.partitionChannels.get(i).intValue());
        }
        return new Page(page.getPositionCount(), blocks);
    }

    public Page getOutput() {
        return null;
    }

    public void finish() {
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished && this.isBlocked().isDone();
    }

    public static class PrestoSparkOutputOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final PrestoSparkRowBuffer rowBuffer;
        private final Function<Page, Page> pagePreprocessor;
        private final PartitionFunction partitionFunction;
        private final List<Integer> partitionChannels;
        private final List<Optional<Block>> partitionConstants;
        private final boolean replicateNullsAndAny;
        private final OptionalInt nullChannel;

        public PrestoSparkOutputOperatorFactory(int operatorId, PlanNodeId planNodeId, PrestoSparkRowBuffer rowBuffer, Function<Page, Page> pagePreprocessor, PartitionFunction partitionFunction, List<Integer> partitionChannels, List<Optional<Block>> partitionConstants, boolean replicateNullsAndAny, OptionalInt nullChannel) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.rowBuffer = Objects.requireNonNull(rowBuffer, "rowBuffer is null");
            this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
            this.partitionFunction = Objects.requireNonNull(partitionFunction, "partitionFunction is null");
            this.partitionChannels = Objects.requireNonNull(partitionChannels, "partitionChannels is null");
            this.partitionConstants = Objects.requireNonNull(partitionConstants, "partitionConstants is null");
            this.replicateNullsAndAny = replicateNullsAndAny;
            this.nullChannel = Objects.requireNonNull(nullChannel, "nullChannel is null");
        }

        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, PrestoSparkOutputOperator.class.getSimpleName());
            return new PrestoSparkOutputOperator(operatorContext, this.rowBuffer, this.pagePreprocessor, this.partitionFunction, this.partitionChannels, this.partitionConstants, this.replicateNullsAndAny, this.nullChannel);
        }

        public void noMoreOperators() {
        }

        public OperatorFactory duplicate() {
            return new PrestoSparkOutputOperatorFactory(this.operatorId, this.planNodeId, this.rowBuffer, this.pagePreprocessor, this.partitionFunction, this.partitionChannels, this.partitionConstants, this.replicateNullsAndAny, this.nullChannel);
        }
    }

    private static class ConstantPartitionFunction
    implements PartitionFunction {
        private ConstantPartitionFunction() {
        }

        public int getPartitionCount() {
            return 1;
        }

        public int getPartition(Page page, int position) {
            return 0;
        }
    }

    public static class PrestoSparkOutputFactory
    implements OutputFactory {
        private static final OutputPartitioning SINGLE_PARTITION = new OutputPartitioning((PartitionFunction)new ConstantPartitionFunction(), (List)ImmutableList.of(), (List)ImmutableList.of(), false, OptionalInt.empty());
        private final PrestoSparkRowBuffer rowBuffer;

        public PrestoSparkOutputFactory(PrestoSparkRowBuffer rowBuffer) {
            this.rowBuffer = Objects.requireNonNull(rowBuffer, "rowBuffer is null");
        }

        public OperatorFactory createOutputOperator(int operatorId, PlanNodeId planNodeId, List<Type> types, Function<Page, Page> pagePreprocessor, Optional<OutputPartitioning> outputPartitioning, PagesSerdeFactory serdeFactory) {
            OutputPartitioning partitioning = outputPartitioning.orElse(SINGLE_PARTITION);
            return new PrestoSparkOutputOperatorFactory(operatorId, planNodeId, this.rowBuffer, pagePreprocessor, partitioning.getPartitionFunction(), partitioning.getPartitionChannels(), (List)partitioning.getPartitionConstants().stream().map(constant -> constant.map(ConstantExpression::getValueBlock)).collect(ImmutableList.toImmutableList()), partitioning.isReplicateNullsAndAny(), partitioning.getNullChannel());
        }
    }
}

