/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.Session;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spark.classloader_interface.PrestoSparkRow;
import com.facebook.presto.spark.execution.PrestoSparkRemoteSourceOperator;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.RemoteSourceFactory;
import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PrestoSparkRemoteSourceFactory
implements RemoteSourceFactory {
    private final Map<PlanNodeId, Iterator<PrestoSparkRow>> inputs;

    public PrestoSparkRemoteSourceFactory(Map<PlanNodeId, Iterator<PrestoSparkRow>> inputs) {
        this.inputs = ImmutableMap.copyOf(Objects.requireNonNull(inputs, "inputs is null"));
    }

    public OperatorFactory createRemoteSource(Session session, int operatorId, PlanNodeId planNodeId, List<Type> types) {
        return new PrestoSparkRemoteSourceOperator.SparkRemoteSourceOperatorFactory(operatorId, planNodeId, Objects.requireNonNull(this.inputs.get(planNodeId), String.format("input is missing for plan node: %s", planNodeId)), types);
    }

    public OperatorFactory createMergeRemoteSource(Session session, int operatorId, PlanNodeId planNodeId, List<Type> types, List<Integer> outputChannels, List<Integer> sortChannels, List<SortOrder> sortOrder) {
        throw new UnsupportedOperationException();
    }
}

