/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.spark.classloader_interface.PrestoSparkRow;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.UpdatablePageSource;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.Slices;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

public class PrestoSparkRemoteSourceOperator
implements SourceOperator {
    private final PlanNodeId sourceId;
    private final OperatorContext operatorContext;
    private final Iterator<PrestoSparkRow> iterator;
    private final List<Type> types;
    private boolean finished;

    public PrestoSparkRemoteSourceOperator(PlanNodeId sourceId, OperatorContext operatorContext, Iterator<PrestoSparkRow> iterator, List<Type> types) {
        this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.iterator = Objects.requireNonNull(iterator, "iterator is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
    }

    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    public boolean needsInput() {
        return false;
    }

    public void addInput(Page page) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getOutput() {
        if (this.finished) {
            return null;
        }
        PageBuilder pageBuilder = new PageBuilder(this.types);
        Iterator<PrestoSparkRow> iterator = this.iterator;
        synchronized (iterator) {
            while (this.iterator.hasNext() && !pageBuilder.isFull()) {
                PrestoSparkRow row = this.iterator.next();
                BasicSliceInput sliceInput = new BasicSliceInput(Slices.wrappedBuffer((byte[])row.getBytes(), (int)0, (int)row.getLength()));
                pageBuilder.declarePosition();
                for (int channel = 0; channel < this.types.size(); ++channel) {
                    BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(channel);
                    blockBuilder.readPositionFrom((SliceInput)sliceInput);
                }
                sliceInput.close();
            }
            if (!this.iterator.hasNext()) {
                this.finished = true;
            }
        }
        if (pageBuilder.isEmpty()) {
            return null;
        }
        return pageBuilder.build();
    }

    public void finish() {
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    public Supplier<Optional<UpdatablePageSource>> addSplit(Split split) {
        throw new UnsupportedOperationException();
    }

    public void noMoreSplits() {
        throw new UnsupportedOperationException();
    }

    public static class SparkRemoteSourceOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Iterator<PrestoSparkRow> iterator;
        private final List<Type> types;
        private boolean closed;

        public SparkRemoteSourceOperatorFactory(int operatorId, PlanNodeId planNodeId, Iterator<PrestoSparkRow> iterator, List<Type> types) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.iterator = Objects.requireNonNull(iterator, "iterator is null");
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        }

        public PlanNodeId getSourceId() {
            return this.planNodeId;
        }

        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"operator factory is closed");
            return new PrestoSparkRemoteSourceOperator(this.planNodeId, driverContext.addOperatorContext(this.operatorId, this.planNodeId, PrestoSparkRemoteSourceOperator.class.getSimpleName()), this.iterator, this.types);
        }

        public void noMoreOperators() {
            this.closed = true;
        }
    }
}

