/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.presto.execution.buffer.OutputBufferMemoryManager;
import com.facebook.presto.spark.classloader_interface.PrestoSparkRow;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import javax.annotation.concurrent.GuardedBy;

public class PrestoSparkRowBuffer {
    private final OutputBufferMemoryManager memoryManager;
    private final Object monitor = new Object();
    @GuardedBy(value="monitor")
    private final Queue<PrestoSparkRow> buffer = new ArrayDeque<PrestoSparkRow>();
    @GuardedBy(value="monitor")
    private boolean finished;

    public PrestoSparkRowBuffer(OutputBufferMemoryManager memoryManager) {
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
    }

    public ListenableFuture<?> isFull() {
        return this.memoryManager.getBufferBlockedFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(PrestoSparkRow row) {
        Objects.requireNonNull(row, "row is null");
        Object object = this.monitor;
        synchronized (object) {
            this.buffer.add(row);
            this.monitor.notify();
        }
        this.memoryManager.updateMemoryUsage(row.getRetainedSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNoMoreRows() {
        this.memoryManager.setNoBlockOnFull();
        Object object = this.monitor;
        synchronized (object) {
            this.finished = true;
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRowsBuffered() {
        Object object = this.monitor;
        synchronized (object) {
            return !this.buffer.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrestoSparkRow get() throws InterruptedException {
        PrestoSparkRow row = null;
        Object object = this.monitor;
        synchronized (object) {
            while (this.buffer.isEmpty() && !this.finished) {
                this.monitor.wait();
            }
            if (!this.buffer.isEmpty()) {
                row = this.buffer.poll();
            }
        }
        if (row != null) {
            this.memoryManager.updateMemoryUsage(-row.getRetainedSize());
        }
        return row;
    }
}

