/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.execution;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.facebook.airlift.stats.GcMonitor;
import com.facebook.airlift.stats.TestingGcMonitor;
import com.facebook.presto.Session;
import com.facebook.presto.execution.ScheduledSplit;
import com.facebook.presto.execution.StageExecutionId;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.execution.buffer.OutputBufferMemoryManager;
import com.facebook.presto.memory.MemoryPool;
import com.facebook.presto.memory.NodeMemoryConfig;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.operator.Driver;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.spark.PrestoSparkAuthenticatorProvider;
import com.facebook.presto.spark.PrestoSparkTaskDescriptor;
import com.facebook.presto.spark.classloader_interface.IPrestoSparkTaskExecutor;
import com.facebook.presto.spark.classloader_interface.IPrestoSparkTaskExecutorFactory;
import com.facebook.presto.spark.classloader_interface.PrestoSparkRow;
import com.facebook.presto.spark.classloader_interface.PrestoSparkTaskInputs;
import com.facebook.presto.spark.classloader_interface.SerializedPrestoSparkTaskDescriptor;
import com.facebook.presto.spark.classloader_interface.SerializedTaskStats;
import com.facebook.presto.spark.execution.PrestoSparkOutputOperator;
import com.facebook.presto.spark.execution.PrestoSparkRemoteSourceFactory;
import com.facebook.presto.spark.execution.PrestoSparkRowBuffer;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spiller.NodeSpillConfig;
import com.facebook.presto.spiller.SpillSpaceTracker;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.RemoteSourceFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import org.apache.spark.util.CollectionAccumulator;
import scala.Tuple2;

public class PrestoSparkTaskExecutorFactory
implements IPrestoSparkTaskExecutorFactory {
    private static final Logger log = Logger.get(PrestoSparkTaskExecutorFactory.class);
    private final SessionPropertyManager sessionPropertyManager;
    private final JsonCodec<PrestoSparkTaskDescriptor> taskDescriptorJsonCodec;
    private final JsonCodec<TaskStats> taskStatsJsonCodec;
    private final Executor notificationExecutor;
    private final ScheduledExecutorService yieldExecutor;
    private final LocalExecutionPlanner localExecutionPlanner;
    private final Set<PrestoSparkAuthenticatorProvider> authenticatorProviders;
    private final DataSize maxUserMemory;
    private final DataSize maxTotalMemory;
    private final DataSize maxSpillMemory;
    private final DataSize sinkMaxBufferSize;
    private final boolean perOperatorCpuTimerEnabled;
    private final boolean cpuTimerEnabled;
    private final boolean perOperatorAllocationTrackingEnabled;
    private final boolean allocationTrackingEnabled;

    @Inject
    public PrestoSparkTaskExecutorFactory(SessionPropertyManager sessionPropertyManager, JsonCodec<PrestoSparkTaskDescriptor> taskDescriptorJsonCodec, JsonCodec<TaskStats> taskStatsJsonCodec, Executor notificationExecutor, ScheduledExecutorService yieldExecutor, LocalExecutionPlanner localExecutionPlanner, Set<PrestoSparkAuthenticatorProvider> authenticatorProviders, TaskManagerConfig taskManagerConfig, NodeMemoryConfig nodeMemoryConfig, NodeSpillConfig nodeSpillConfig) {
        this(sessionPropertyManager, taskDescriptorJsonCodec, taskStatsJsonCodec, notificationExecutor, yieldExecutor, localExecutionPlanner, authenticatorProviders, Objects.requireNonNull(nodeMemoryConfig, "nodeMemoryConfig is null").getMaxQueryMemoryPerNode(), Objects.requireNonNull(nodeMemoryConfig, "nodeMemoryConfig is null").getMaxQueryTotalMemoryPerNode(), Objects.requireNonNull(nodeSpillConfig, "nodeSpillConfig is null").getMaxSpillPerNode(), Objects.requireNonNull(taskManagerConfig, "taskManagerConfig is null").getSinkMaxBufferSize(), Objects.requireNonNull(taskManagerConfig, "taskManagerConfig is null").isPerOperatorCpuTimerEnabled(), Objects.requireNonNull(taskManagerConfig, "taskManagerConfig is null").isTaskCpuTimerEnabled(), Objects.requireNonNull(taskManagerConfig, "taskManagerConfig is null").isPerOperatorAllocationTrackingEnabled(), Objects.requireNonNull(taskManagerConfig, "taskManagerConfig is null").isTaskAllocationTrackingEnabled());
    }

    public PrestoSparkTaskExecutorFactory(SessionPropertyManager sessionPropertyManager, JsonCodec<PrestoSparkTaskDescriptor> taskDescriptorJsonCodec, JsonCodec<TaskStats> taskStatsJsonCodec, Executor notificationExecutor, ScheduledExecutorService yieldExecutor, LocalExecutionPlanner localExecutionPlanner, Set<PrestoSparkAuthenticatorProvider> authenticatorProviders, DataSize maxUserMemory, DataSize maxTotalMemory, DataSize maxSpillMemory, DataSize sinkMaxBufferSize, boolean perOperatorCpuTimerEnabled, boolean cpuTimerEnabled, boolean perOperatorAllocationTrackingEnabled, boolean allocationTrackingEnabled) {
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.taskDescriptorJsonCodec = Objects.requireNonNull(taskDescriptorJsonCodec, "sparkTaskDescriptorJsonCodec is null");
        this.taskStatsJsonCodec = Objects.requireNonNull(taskStatsJsonCodec, "taskStatsJsonCodec is null");
        this.notificationExecutor = Objects.requireNonNull(notificationExecutor, "notificationExecutor is null");
        this.yieldExecutor = Objects.requireNonNull(yieldExecutor, "yieldExecutor is null");
        this.localExecutionPlanner = Objects.requireNonNull(localExecutionPlanner, "localExecutionPlanner is null");
        this.authenticatorProviders = ImmutableSet.copyOf((Collection)Objects.requireNonNull(authenticatorProviders, "authenticatorProviders is null"));
        this.maxUserMemory = Objects.requireNonNull(maxUserMemory, "maxUserMemory is null");
        this.maxTotalMemory = Objects.requireNonNull(maxTotalMemory, "maxTotalMemory is null");
        this.maxSpillMemory = Objects.requireNonNull(maxSpillMemory, "maxSpillMemory is null");
        this.sinkMaxBufferSize = Objects.requireNonNull(sinkMaxBufferSize, "sinkMaxBufferSize is null");
        this.perOperatorCpuTimerEnabled = perOperatorCpuTimerEnabled;
        this.cpuTimerEnabled = cpuTimerEnabled;
        this.perOperatorAllocationTrackingEnabled = perOperatorAllocationTrackingEnabled;
        this.allocationTrackingEnabled = allocationTrackingEnabled;
    }

    public IPrestoSparkTaskExecutor create(int partitionId, int attemptNumber, SerializedPrestoSparkTaskDescriptor serializedTaskDescriptor, PrestoSparkTaskInputs inputs, CollectionAccumulator<SerializedTaskStats> taskStatsCollector) {
        PrestoSparkTaskDescriptor taskDescriptor = (PrestoSparkTaskDescriptor)this.taskDescriptorJsonCodec.fromJson(serializedTaskDescriptor.getBytes());
        ImmutableMap.Builder extraAuthenticators = ImmutableMap.builder();
        this.authenticatorProviders.forEach(provider -> extraAuthenticators.putAll(provider.getTokenAuthenticators()));
        Session session = taskDescriptor.getSession().toSession(this.sessionPropertyManager, taskDescriptor.getExtraCredentials(), (Map)extraAuthenticators.build());
        PlanFragment fragment = taskDescriptor.getFragment();
        StageId stageId = new StageId(session.getQueryId(), fragment.getId().getId());
        TaskId taskId = new TaskId(new StageExecutionId(stageId, 0), partitionId);
        log.info("Task [%s] received %d splits.", new Object[]{taskId, taskDescriptor.getSources().stream().mapToInt(taskSource -> taskSource.getSplits().size()).sum()});
        MemoryPool memoryPool = new MemoryPool(new MemoryPoolId("spark-executor-memory-pool"), this.maxTotalMemory);
        SpillSpaceTracker spillSpaceTracker = new SpillSpaceTracker(this.maxSpillMemory);
        QueryContext queryContext = new QueryContext(session.getQueryId(), this.maxUserMemory, this.maxTotalMemory, memoryPool, (GcMonitor)new TestingGcMonitor(), this.notificationExecutor, this.yieldExecutor, this.maxSpillMemory, spillSpaceTracker);
        TaskContext taskContext = queryContext.addTaskContext(new TaskStateMachine(taskId, this.notificationExecutor), session, this.perOperatorCpuTimerEnabled, this.cpuTimerEnabled, this.perOperatorAllocationTrackingEnabled, this.allocationTrackingEnabled, false);
        OutputBufferMemoryManager memoryManager = new OutputBufferMemoryManager(this.sinkMaxBufferSize.toBytes(), () -> queryContext.getTaskContextByTaskId(taskId).localSystemMemoryContext(), this.notificationExecutor);
        PrestoSparkRowBuffer rowBuffer = new PrestoSparkRowBuffer(memoryManager);
        ImmutableMap sparkInputs = (ImmutableMap)inputs.getInputsMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> new PlanNodeId((String)entry.getKey()), entry -> Iterators.transform((Iterator)((Iterator)entry.getValue()), tuple -> (PrestoSparkRow)tuple._2)));
        LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan = this.localExecutionPlanner.plan(taskContext, fragment.getRoot(), fragment.getPartitioningScheme(), fragment.getStageExecutionDescriptor(), fragment.getTableScanSchedulingOrder(), (OutputFactory)new PrestoSparkOutputOperator.PrestoSparkOutputFactory(rowBuffer), (RemoteSourceFactory)new PrestoSparkRemoteSourceFactory((Map<PlanNodeId, Iterator<PrestoSparkRow>>)sparkInputs), taskDescriptor.getTableWriteInfo());
        List<Driver> drivers = this.createDrivers(localExecutionPlan, taskContext, fragment.getTableScanSchedulingOrder(), taskDescriptor.getSources());
        return new PrestoSparkTaskExecutor(taskContext, drivers, rowBuffer, this.taskStatsJsonCodec, taskStatsCollector);
    }

    public List<Driver> createDrivers(LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan, TaskContext taskContext, List<PlanNodeId> tableScanSchedulingOrder, List<TaskSource> sources) {
        boolean partitioned;
        ArrayList<Driver> drivers = new ArrayList<Driver>();
        HashMap driverFactoriesBySource = new HashMap();
        for (DriverFactory driverFactory : localExecutionPlan.getDriverFactories()) {
            for (int i = 0; i < driverFactory.getDriverInstances().orElse(1); ++i) {
                if (driverFactory.getSourceId().isPresent()) {
                    partitioned = tableScanSchedulingOrder.contains(driverFactory.getSourceId().get());
                    if (partitioned) {
                        Preconditions.checkState((driverFactoriesBySource.put(driverFactory.getSourceId().get(), driverFactory) == null ? 1 : 0) != 0);
                        continue;
                    }
                    DriverContext driverContext = taskContext.addPipelineContext(driverFactory.getPipelineId(), driverFactory.isInputDriver(), driverFactory.isOutputDriver(), false).addDriverContext();
                    Driver driver = driverFactory.createDriver(driverContext);
                    drivers.add(driver);
                    continue;
                }
                DriverContext driverContext = taskContext.addPipelineContext(driverFactory.getPipelineId(), driverFactory.isInputDriver(), driverFactory.isOutputDriver(), false).addDriverContext();
                Driver driver = driverFactory.createDriver(driverContext);
                drivers.add(driver);
            }
        }
        for (TaskSource source : sources) {
            DriverFactory driverFactory = (DriverFactory)driverFactoriesBySource.get(source.getPlanNodeId());
            Preconditions.checkState((driverFactory != null ? 1 : 0) != 0);
            partitioned = tableScanSchedulingOrder.contains(driverFactory.getSourceId().get());
            for (ScheduledSplit split : source.getSplits()) {
                DriverContext driverContext = taskContext.addPipelineContext(driverFactory.getPipelineId(), driverFactory.isInputDriver(), driverFactory.isOutputDriver(), partitioned).addDriverContext();
                Driver driver = driverFactory.createDriver(driverContext);
                driver.updateSource(new TaskSource(split.getPlanNodeId(), (Set)ImmutableSet.of((Object)split), true));
                drivers.add(driver);
            }
        }
        for (DriverFactory driverFactory : localExecutionPlan.getDriverFactories()) {
            driverFactory.noMoreDrivers();
        }
        return ImmutableList.copyOf(drivers);
    }

    private static class PrestoSparkTaskExecutor
    extends AbstractIterator<Tuple2<Integer, PrestoSparkRow>>
    implements IPrestoSparkTaskExecutor {
        private final TaskContext taskContext;
        private final List<Driver> drivers;
        private final PrestoSparkRowBuffer rowBuffer;
        private final JsonCodec<TaskStats> taskStatsJsonCodec;
        private final CollectionAccumulator<SerializedTaskStats> taskStatsCollector;

        private PrestoSparkTaskExecutor(TaskContext taskContext, List<Driver> drivers, PrestoSparkRowBuffer rowBuffer, JsonCodec<TaskStats> taskStatsJsonCodec, CollectionAccumulator<SerializedTaskStats> taskStatsCollector) {
            this.taskContext = Objects.requireNonNull(taskContext, "taskContext is null");
            this.drivers = ImmutableList.copyOf((Collection)Objects.requireNonNull(drivers, "drivers is null"));
            this.rowBuffer = Objects.requireNonNull(rowBuffer, "rowBuffer is null");
            this.taskStatsJsonCodec = Objects.requireNonNull(taskStatsJsonCodec, "taskStatsJsonCodec is null");
            this.taskStatsCollector = Objects.requireNonNull(taskStatsCollector, "taskStatsCollector is null");
        }

        protected Tuple2<Integer, PrestoSparkRow> computeNext() {
            boolean done = false;
            while (!done && !this.rowBuffer.hasRowsBuffered()) {
                boolean processed = false;
                for (Driver driver : this.drivers) {
                    if (driver.isFinished()) continue;
                    driver.process();
                    processed = true;
                }
                done = !processed;
            }
            if (done) {
                this.rowBuffer.setNoMoreRows();
            }
            if (!this.rowBuffer.hasRowsBuffered()) {
                Verify.verify((boolean)done, (String)"all drivers must be done if no rows are in the buffer", (Object[])new Object[0]);
                return (Tuple2)this.endOfData();
            }
            try {
                PrestoSparkRow row = Objects.requireNonNull(this.rowBuffer.get(), "row is null");
                return new Tuple2((Object)row.getPartition(), (Object)row);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }
}

