/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.planner;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.presto.Session;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.ScheduledSplit;
import com.facebook.presto.execution.TaskSource;
import com.facebook.presto.execution.scheduler.StreamingPlanSection;
import com.facebook.presto.execution.scheduler.StreamingSubPlan;
import com.facebook.presto.execution.scheduler.TableWriteInfo;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.StageExecutionDescriptor;
import com.facebook.presto.spark.planner.PrestoSparkPlan;
import com.facebook.presto.spark.planner.PrestoSparkSubPlan;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.split.SplitSource;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import javax.inject.Inject;

public class PrestoSparkSplitEnumerator {
    private static final int SPLIT_BATCH_SIZE = 1000;
    private final SplitManager splitManager;
    private final Metadata metadata;

    @Inject
    public PrestoSparkSplitEnumerator(SplitManager splitManager, Metadata metadata) {
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public PrestoSparkPlan preparePlan(Session session, SubPlan plan) {
        StreamingPlanSection streamingPlanSection = StreamingPlanSection.extractStreamingSections((SubPlan)plan);
        Preconditions.checkState((boolean)streamingPlanSection.getChildren().isEmpty(), (Object)"expected no materialized exchanges");
        StreamingSubPlan streamingSubPlan = streamingPlanSection.getPlan();
        return new PrestoSparkPlan(this.resolveTaskSources(session, plan), TableWriteInfo.createTableWriteInfo((StreamingSubPlan)streamingSubPlan, (Metadata)this.metadata, (Session)session));
    }

    private PrestoSparkSubPlan resolveTaskSources(Session session, SubPlan plan) {
        return new PrestoSparkSubPlan(plan.getFragment(), this.resolveTaskSources(session, plan.getFragment()), (List)plan.getChildren().stream().map(children -> this.resolveTaskSources(session, (SubPlan)children)).collect(ImmutableList.toImmutableList()));
    }

    private List<TaskSource> resolveTaskSources(Session session, PlanFragment fragment) {
        StageExecutionDescriptor stageExecutionDescriptor = fragment.getStageExecutionDescriptor();
        StageExecutionDescriptor.StageExecutionStrategy stageExecutionStrategy = stageExecutionDescriptor.getStageExecutionStrategy();
        Preconditions.checkArgument((stageExecutionStrategy == StageExecutionDescriptor.StageExecutionStrategy.UNGROUPED_EXECUTION ? 1 : 0) != 0, (String)"Unsupported stage execution strategy: %s", (Object)stageExecutionStrategy);
        ArrayList<TaskSource> sources = new ArrayList<TaskSource>();
        long sequenceId = 0L;
        for (TableScanNode tableScan : PrestoSparkSplitEnumerator.findTableScanNodes(fragment.getRoot())) {
            SplitSource splitSource = this.splitManager.getSplits(session, tableScan.getTable(), ConnectorSplitManager.SplitSchedulingStrategy.UNGROUPED_SCHEDULING);
            ImmutableSet.Builder scheduledSplits = ImmutableSet.builder();
            while (!splitSource.isFinished()) {
                for (Split split : PrestoSparkSplitEnumerator.getNextBatch(splitSource)) {
                    scheduledSplits.add((Object)new ScheduledSplit(sequenceId++, tableScan.getId(), split));
                }
            }
            sources.add(new TaskSource(tableScan.getId(), (Set)scheduledSplits.build(), true));
        }
        return sources;
    }

    private static List<TableScanNode> findTableScanNodes(PlanNode node) {
        return PlanNodeSearcher.searchFrom((PlanNode)node).where(TableScanNode.class::isInstance).findAll();
    }

    private static List<Split> getNextBatch(SplitSource splitSource) {
        return ((SplitSource.SplitBatch)MoreFutures.getFutureValue((Future)splitSource.getNextBatch(NotPartitionedPartitionHandle.NOT_PARTITIONED, Lifespan.taskWide(), 1000))).getSplits();
    }
}

