/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.DirectoryLister;
import com.facebook.presto.hive.HiveFileInfo;
import com.facebook.presto.hive.NamenodeStats;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.util.HiveFileIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;

public class HadoopDirectoryLister
implements DirectoryLister {
    @Override
    public Iterator<HiveFileInfo> list(FileSystem fileSystem, Table table, Path path, NamenodeStats namenodeStats, HiveFileIterator.NestedDirectoryPolicy nestedDirectoryPolicy, PathFilter pathFilter) {
        return new HiveFileIterator(path, p -> new HadoopFileInfoIterator((RemoteIterator<LocatedFileStatus>)fileSystem.listLocatedStatus(p)), namenodeStats, nestedDirectoryPolicy, pathFilter);
    }

    public static class HadoopFileInfoIterator
    implements RemoteIterator<HiveFileInfo> {
        private final RemoteIterator<LocatedFileStatus> locatedFileStatusIterator;

        public HadoopFileInfoIterator(RemoteIterator<LocatedFileStatus> locatedFileStatusIterator) {
            this.locatedFileStatusIterator = Objects.requireNonNull(locatedFileStatusIterator, "locatedFileStatusIterator is null");
        }

        public boolean hasNext() throws IOException {
            return this.locatedFileStatusIterator.hasNext();
        }

        public HiveFileInfo next() throws IOException {
            return HiveFileInfo.createHiveFileInfo((LocatedFileStatus)this.locatedFileStatusIterator.next(), Optional.empty());
        }
    }
}

