/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.cache.CacheConfig;
import com.facebook.presto.cache.CacheManager;
import com.facebook.presto.cache.CachingFileSystem;
import com.facebook.presto.cache.ForCachingFileSystem;
import com.facebook.presto.hadoop.FileSystemFactory;
import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.util.ConfigurationUtils;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;

public class HiveCachingHdfsConfiguration
implements HdfsConfiguration {
    private final HdfsConfiguration hiveHdfsConfiguration;
    private final CacheManager cacheManager;
    private final boolean cacheValidationEnabled;

    @Inject
    public HiveCachingHdfsConfiguration(@ForCachingFileSystem HdfsConfiguration hdfsConfiguration, CacheConfig cacheConfig, CacheManager cacheManager) {
        this.hiveHdfsConfiguration = Objects.requireNonNull(hdfsConfiguration, "hiveHdfsConfiguration is null");
        this.cacheManager = Objects.requireNonNull(cacheManager, "CacheManager is null");
        this.cacheValidationEnabled = Objects.requireNonNull(cacheConfig, "cacheConfig is null").isValidationEnabled();
    }

    public Configuration getConfiguration(HdfsEnvironment.HdfsContext context, URI uri) {
        CachingJobConf config = new CachingJobConf((factoryConfig, factoryUri) -> {
            try {
                return new CachingFileSystem(factoryUri, factoryConfig, this.cacheManager, new Path(factoryUri).getFileSystem(this.hiveHdfsConfiguration.getConfiguration(context, factoryUri)), this.cacheValidationEnabled);
            }
            catch (IOException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "cannot create caching file system", (Throwable)e);
            }
        });
        Configuration defaultConfig = this.hiveHdfsConfiguration.getConfiguration(context, uri);
        ConfigurationUtils.copy(defaultConfig, (Configuration)config);
        return config;
    }

    private static class CachingJobConf
    extends JobConf
    implements FileSystemFactory {
        private final BiFunction<Configuration, URI, FileSystem> factory;

        private CachingJobConf(BiFunction<Configuration, URI, FileSystem> factory) {
            super(false);
            this.factory = Objects.requireNonNull(factory, "factory is null");
        }

        public FileSystem createFileSystem(URI uri) {
            return this.factory.apply((Configuration)this, uri);
        }
    }
}

