/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;

public class HiveFileInfo
implements Comparable {
    private final Path path;
    private final boolean isDirectory;
    private final BlockLocation[] blockLocations;
    private final long length;
    private final Optional<byte[]> extraFileInfo;

    public static HiveFileInfo createHiveFileInfo(LocatedFileStatus locatedFileStatus, Optional<byte[]> extraFileContext) {
        return new HiveFileInfo(locatedFileStatus.getPath(), locatedFileStatus.isDirectory(), locatedFileStatus.getBlockLocations(), locatedFileStatus.getLen(), extraFileContext);
    }

    private HiveFileInfo(Path path, boolean isDirectory, BlockLocation[] blockLocations, long length, Optional<byte[]> extraFileInfo) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.isDirectory = isDirectory;
        this.blockLocations = blockLocations;
        this.length = length;
        this.extraFileInfo = Objects.requireNonNull(extraFileInfo, "extraFileInfo is null");
    }

    public Path getPath() {
        return this.path;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public BlockLocation[] getBlockLocations() {
        return this.blockLocations;
    }

    public long getLength() {
        return this.length;
    }

    public Optional<byte[]> getExtraFileInfo() {
        return this.extraFileInfo;
    }

    public int compareTo(Object o) {
        HiveFileInfo other = (HiveFileInfo)o;
        return this.getPath().compareTo((Object)other.getPath());
    }
}

