/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBucketFunction;
import com.facebook.presto.hive.HivePartitionHandle;
import com.facebook.presto.hive.HivePartitioningHandle;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.spi.BucketFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorBucketNodeMap;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class HiveNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        HivePartitioningHandle handle = (HivePartitioningHandle)partitioningHandle;
        List<HiveType> hiveTypes = handle.getHiveTypes();
        return new HiveBucketFunction(bucketCount, hiveTypes);
    }

    public ConnectorBucketNodeMap getBucketNodeMap(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Node> sortedNodes) {
        HivePartitioningHandle handle = (HivePartitioningHandle)partitioningHandle;
        NodeSelectionStrategy nodeSelectionStrategy = HiveSessionProperties.getNodeSelectionStrategy(session);
        int bucketCount = handle.getBucketCount();
        switch (nodeSelectionStrategy) {
            case HARD_AFFINITY: 
            case SOFT_AFFINITY: {
                return ConnectorBucketNodeMap.createBucketNodeMap((List)((List)Stream.generate(() -> sortedNodes).flatMap(Collection::stream).limit(bucketCount).collect(ImmutableList.toImmutableList())), (NodeSelectionStrategy)nodeSelectionStrategy);
            }
            case NO_PREFERENCE: {
                return ConnectorBucketNodeMap.createBucketNodeMap((int)bucketCount);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NODE_SELECTION_NOT_SUPPORTED, String.format("Unsupported node selection strategy %s", nodeSelectionStrategy));
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return value -> ((HiveSplit)value).getReadBucketNumber().orElseThrow(() -> new IllegalArgumentException("Bucket number not set in split"));
    }

    public List<ConnectorPartitionHandle> listPartitionHandles(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        HivePartitioningHandle handle = (HivePartitioningHandle)partitioningHandle;
        int bucketCount = handle.getBucketCount();
        return (List)IntStream.range(0, bucketCount).mapToObj(HivePartitionHandle::new).collect(ImmutableList.toImmutableList());
    }
}

