/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.facebook.hive.orc.OrcConf;
import com.facebook.presto.hadoop.FileSystemFactory;
import com.facebook.presto.hive.HiveCompressionCodec;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.mapred.JobConf;

public final class ConfigurationUtils {
    private static final Configuration INITIAL_CONFIGURATION;

    private ConfigurationUtils() {
    }

    public static Configuration getInitialConfiguration() {
        return ConfigurationUtils.copy(INITIAL_CONFIGURATION);
    }

    public static Configuration copy(Configuration configuration) {
        Configuration copy = new Configuration(false);
        ConfigurationUtils.copy(configuration, copy);
        return copy;
    }

    public static void copy(Configuration from, Configuration to) {
        for (Map.Entry entry : from) {
            to.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static JobConf toJobConf(Configuration conf) {
        if (conf instanceof JobConf) {
            return (JobConf)conf;
        }
        return new JobConf(conf);
    }

    public static JobConf configureCompression(Configuration config, HiveCompressionCodec compression) {
        JobConf result;
        if (config instanceof FileSystemFactory) {
            Preconditions.checkArgument((boolean)(config instanceof JobConf), (String)"config is not an instance of JobConf: %s", config.getClass());
            result = (JobConf)config;
        } else {
            result = new JobConf(false);
            ConfigurationUtils.copy(config, (Configuration)result);
        }
        ConfigurationUtils.setCompressionProperties((Configuration)result, compression);
        return result;
    }

    private static void setCompressionProperties(Configuration config, HiveCompressionCodec compression) {
        boolean compressed = compression != HiveCompressionCodec.NONE;
        config.setBoolean(HiveConf.ConfVars.COMPRESSRESULT.varname, compressed);
        config.setBoolean("mapred.output.compress", compressed);
        config.setBoolean("mapreduce.output.fileoutputformat.compress", compressed);
        config.set(HiveConf.ConfVars.HIVE_ORC_DEFAULT_COMPRESS.varname, compression.getOrcCompressionKind().name());
        config.set(OrcConf.ConfVars.HIVE_ORC_COMPRESSION.varname, compression.getOrcCompressionKind().name());
        config.set(OrcFile.OrcTableProperties.COMPRESSION.getPropName(), compression.getOrcCompressionKind().name());
        if (compression.getCodec().isPresent()) {
            config.set("mapred.output.compression.codec", compression.getCodec().get().getName());
            config.set("mapreduce.output.fileoutputformat.compress.codec", compression.getCodec().get().getName());
        } else {
            config.unset("mapred.output.compression.codec");
            config.unset("mapreduce.output.fileoutputformat.compress.codec");
        }
        compression.getParquetCompressionCodec().ifPresent(codec -> config.set("parquet.compression", codec.name()));
        config.set("mapreduce.output.fileoutputformat.compress.type", SequenceFile.CompressionType.BLOCK.toString());
    }

    static {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
        INITIAL_CONFIGURATION = new Configuration(false);
        Configuration defaultConfiguration = new Configuration();
        ConfigurationUtils.copy(defaultConfiguration, INITIAL_CONFIGURATION);
    }
}

