/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet;

import com.facebook.presto.parquet.AbstractParquetDataSource;
import com.facebook.presto.parquet.ParquetDataSourceId;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;

public class FileParquetDataSource
extends AbstractParquetDataSource {
    private final RandomAccessFile input;

    public FileParquetDataSource(File file) throws FileNotFoundException {
        super(new ParquetDataSourceId(file.getAbsolutePath()));
        this.input = new RandomAccessFile(file, "r");
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    protected void readInternal(long position, byte[] buffer, int bufferOffset, int bufferLength) {
        try {
            this.input.seek(position);
            this.input.readFully(buffer, bufferOffset, bufferLength);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

