/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.facebook.presto.parquet.DataPage;
import com.facebook.presto.parquet.DataPageV1;
import com.facebook.presto.parquet.DataPageV2;
import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.Field;
import com.facebook.presto.parquet.ParquetEncoding;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.ValuesType;
import com.facebook.presto.parquet.dictionary.Dictionary;
import com.facebook.presto.parquet.reader.BinaryColumnReader;
import com.facebook.presto.parquet.reader.BooleanColumnReader;
import com.facebook.presto.parquet.reader.ColumnChunk;
import com.facebook.presto.parquet.reader.DecimalColumnReaderFactory;
import com.facebook.presto.parquet.reader.DoubleColumnReader;
import com.facebook.presto.parquet.reader.FloatColumnReader;
import com.facebook.presto.parquet.reader.IntColumnReader;
import com.facebook.presto.parquet.reader.LevelNullReader;
import com.facebook.presto.parquet.reader.LevelRLEReader;
import com.facebook.presto.parquet.reader.LevelReader;
import com.facebook.presto.parquet.reader.LevelValuesReader;
import com.facebook.presto.parquet.reader.LongColumnReader;
import com.facebook.presto.parquet.reader.PageReader;
import com.facebook.presto.parquet.reader.TimestampColumnReader;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import org.apache.parquet.io.ParquetDecodingException;

public abstract class PrimitiveColumnReader {
    private static final int EMPTY_LEVEL_VALUE = -1;
    protected final RichColumnDescriptor columnDescriptor;
    protected int definitionLevel = -1;
    protected int repetitionLevel = -1;
    protected ValuesReader valuesReader;
    private int nextBatchSize;
    private LevelReader repetitionReader;
    private LevelReader definitionReader;
    private long totalValueCount;
    private PageReader pageReader;
    private Dictionary dictionary;
    private int currentValueCount;
    private DataPage page;
    private int remainingValueCountInPage;
    private int readOffset;

    protected abstract void readValue(BlockBuilder var1, Type var2);

    protected abstract void skipValue();

    protected boolean isValueNull() {
        return ParquetTypeUtils.isValueNull(this.columnDescriptor.isRequired(), this.definitionLevel, this.columnDescriptor.getMaxDefinitionLevel());
    }

    public static PrimitiveColumnReader createReader(RichColumnDescriptor descriptor) {
        switch (descriptor.getType()) {
            case BOOLEAN: {
                return new BooleanColumnReader(descriptor);
            }
            case INT32: {
                return PrimitiveColumnReader.createDecimalColumnReader(descriptor).orElse(new IntColumnReader(descriptor));
            }
            case INT64: {
                return PrimitiveColumnReader.createDecimalColumnReader(descriptor).orElse(new LongColumnReader(descriptor));
            }
            case INT96: {
                return new TimestampColumnReader(descriptor);
            }
            case FLOAT: {
                return new FloatColumnReader(descriptor);
            }
            case DOUBLE: {
                return new DoubleColumnReader(descriptor);
            }
            case BINARY: {
                return PrimitiveColumnReader.createDecimalColumnReader(descriptor).orElse(new BinaryColumnReader(descriptor));
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return PrimitiveColumnReader.createDecimalColumnReader(descriptor).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, " type FIXED_LEN_BYTE_ARRAY supported as DECIMAL; got " + descriptor.getPrimitiveType().getOriginalType()));
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported parquet type: " + descriptor.getType());
    }

    private static Optional<PrimitiveColumnReader> createDecimalColumnReader(RichColumnDescriptor descriptor) {
        Optional<Type> type = ParquetTypeUtils.createDecimalType(descriptor);
        if (type.isPresent()) {
            DecimalType decimalType = (DecimalType)type.get();
            return Optional.of(DecimalColumnReaderFactory.createReader(descriptor, decimalType.getPrecision(), decimalType.getScale()));
        }
        return Optional.empty();
    }

    public PrimitiveColumnReader(RichColumnDescriptor columnDescriptor) {
        this.columnDescriptor = Objects.requireNonNull(columnDescriptor, "columnDescriptor");
        this.pageReader = null;
    }

    public PageReader getPageReader() {
        return this.pageReader;
    }

    public void setPageReader(PageReader pageReader) {
        this.pageReader = Objects.requireNonNull(pageReader, "pageReader");
        DictionaryPage dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                this.dictionary = dictionaryPage.getEncoding().initDictionary(this.columnDescriptor, dictionaryPage);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not decode the dictionary for " + (Object)((Object)this.columnDescriptor), (Throwable)e);
            }
        } else {
            this.dictionary = null;
        }
        Preconditions.checkArgument((pageReader.getTotalValueCount() > 0L ? 1 : 0) != 0, (Object)"page is empty");
        this.totalValueCount = pageReader.getTotalValueCount();
    }

    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    public ColumnChunk readPrimitive(Field field) throws IOException {
        int valueCount;
        int valuesToRead;
        IntArrayList definitionLevels = new IntArrayList();
        IntArrayList repetitionLevels = new IntArrayList();
        this.seek();
        BlockBuilder blockBuilder = field.getType().createBlockBuilder(null, this.nextBatchSize);
        for (valueCount = 0; valueCount < this.nextBatchSize; valueCount += valuesToRead) {
            if (this.page == null) {
                this.readNextPage();
            }
            valuesToRead = Math.min(this.remainingValueCountInPage, this.nextBatchSize - valueCount);
            this.readValues(blockBuilder, valuesToRead, field.getType(), (IntList)definitionLevels, (IntList)repetitionLevels);
        }
        Preconditions.checkArgument((valueCount == this.nextBatchSize ? 1 : 0) != 0, (String)"valueCount %s not equals to batchSize %s", (int)valueCount, (int)this.nextBatchSize);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return new ColumnChunk(blockBuilder.build(), definitionLevels.toIntArray(), repetitionLevels.toIntArray());
    }

    private void readValues(BlockBuilder blockBuilder, int valuesToRead, Type type, IntList definitionLevels, IntList repetitionLevels) {
        this.processValues(valuesToRead, ignored -> {
            this.readValue(blockBuilder, type);
            definitionLevels.add(this.definitionLevel);
            repetitionLevels.add(this.repetitionLevel);
        });
    }

    private void skipValues(int valuesToRead) {
        this.processValues(valuesToRead, ignored -> this.skipValue());
    }

    private void processValues(int valuesToRead, Consumer<Void> valueConsumer) {
        if (this.definitionLevel == -1 && this.repetitionLevel == -1) {
            this.definitionLevel = this.definitionReader.readLevel();
            this.repetitionLevel = this.repetitionReader.readLevel();
        }
        int valueCount = 0;
        for (int i = 0; i < valuesToRead; ++i) {
            do {
                valueConsumer.accept(null);
                if (++valueCount == this.remainingValueCountInPage) {
                    this.updateValueCounts(valueCount);
                    if (!this.readNextPage()) {
                        return;
                    }
                    valueCount = 0;
                }
                this.repetitionLevel = this.repetitionReader.readLevel();
                this.definitionLevel = this.definitionReader.readLevel();
            } while (this.repetitionLevel != 0);
        }
        this.updateValueCounts(valueCount);
    }

    private void seek() {
        int valuePosition;
        int offset;
        Preconditions.checkArgument(((long)this.currentValueCount <= this.totalValueCount ? 1 : 0) != 0, (Object)"Already read all values in column chunk");
        if (this.readOffset == 0) {
            return;
        }
        for (valuePosition = 0; valuePosition < this.readOffset; valuePosition += offset) {
            if (this.page == null) {
                this.readNextPage();
            }
            offset = Math.min(this.remainingValueCountInPage, this.readOffset - valuePosition);
            this.skipValues(offset);
        }
        Preconditions.checkArgument((valuePosition == this.readOffset ? 1 : 0) != 0, (String)"valuePosition %s must be equal to readOffset %s", (int)valuePosition, (int)this.readOffset);
    }

    private boolean readNextPage() {
        Verify.verify((this.page == null ? 1 : 0) != 0, (String)"readNextPage has to be called when page is null", (Object[])new Object[0]);
        this.page = this.pageReader.readPage();
        if (this.page == null) {
            return false;
        }
        this.remainingValueCountInPage = this.page.getValueCount();
        this.valuesReader = this.page instanceof DataPageV1 ? this.readPageV1((DataPageV1)this.page) : this.readPageV2((DataPageV2)this.page);
        return true;
    }

    private void updateValueCounts(int valuesRead) {
        if (valuesRead == this.remainingValueCountInPage) {
            this.page = null;
            this.valuesReader = null;
        }
        this.remainingValueCountInPage -= valuesRead;
        this.currentValueCount += valuesRead;
    }

    private ValuesReader readPageV1(DataPageV1 page) {
        ValuesReader repetitionLevelReader = page.getRepetitionLevelEncoding().getValuesReader(this.columnDescriptor, ValuesType.REPETITION_LEVEL);
        ValuesReader definitionLevelReader = page.getDefinitionLevelEncoding().getValuesReader(this.columnDescriptor, ValuesType.DEFINITION_LEVEL);
        this.repetitionReader = new LevelValuesReader(repetitionLevelReader);
        this.definitionReader = new LevelValuesReader(definitionLevelReader);
        try {
            byte[] bytes = page.getSlice().getBytes();
            ByteBufferInputStream bufferInputStream = ByteBufferInputStream.wrap((List)ImmutableList.of((Object)ByteBuffer.wrap(bytes)));
            repetitionLevelReader.initFromPage(page.getValueCount(), bufferInputStream);
            int offset = bytes.length - bufferInputStream.available();
            ByteBuffer definitionLevelByteBuffer = ByteBuffer.wrap(bytes, offset, bytes.length - offset);
            ByteBufferInputStream definitionLevelInputStream = ByteBufferInputStream.wrap((List)ImmutableList.of((Object)definitionLevelByteBuffer));
            definitionLevelReader.initFromPage(page.getValueCount(), definitionLevelInputStream);
            offset = bytes.length - definitionLevelInputStream.available();
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, offset, bytes.length - offset);
            return this.initDataReader(page.getValueEncoding(), ByteBufferInputStream.wrap((List)ImmutableList.of((Object)byteBuffer)), page.getValueCount());
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Error reading parquet page " + page + " in column " + (Object)((Object)this.columnDescriptor), (Throwable)e);
        }
    }

    private ValuesReader readPageV2(DataPageV2 page) {
        this.repetitionReader = this.buildLevelRLEReader(this.columnDescriptor.getMaxRepetitionLevel(), page.getRepetitionLevels());
        this.definitionReader = this.buildLevelRLEReader(this.columnDescriptor.getMaxDefinitionLevel(), page.getDefinitionLevels());
        ByteBuffer byteBuffer = ByteBuffer.wrap(page.getSlice().getBytes());
        return this.initDataReader(page.getDataEncoding(), ByteBufferInputStream.wrap((List)ImmutableList.of((Object)byteBuffer)), page.getValueCount());
    }

    private LevelReader buildLevelRLEReader(int maxLevel, Slice slice) {
        if (maxLevel == 0) {
            return new LevelNullReader();
        }
        return new LevelRLEReader(new RunLengthBitPackingHybridDecoder(BytesUtils.getWidthFromMaxInt((int)maxLevel), (InputStream)new ByteArrayInputStream(slice.getBytes())));
    }

    private ValuesReader initDataReader(ParquetEncoding dataEncoding, ByteBufferInputStream inputStream, int valueCount) {
        ValuesReader valuesReader;
        if (dataEncoding.usesDictionary()) {
            if (this.dictionary == null) {
                throw new ParquetDecodingException("Dictionary is missing for Page");
            }
            valuesReader = dataEncoding.getDictionaryBasedValuesReader(this.columnDescriptor, ValuesType.VALUES, this.dictionary);
        } else {
            valuesReader = dataEncoding.getValuesReader(this.columnDescriptor, ValuesType.VALUES);
        }
        try {
            valuesReader.initFromPage(valueCount, inputStream);
            return valuesReader;
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Error reading parquet page in column " + (Object)((Object)this.columnDescriptor), (Throwable)e);
        }
    }
}

