/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.metadata;

import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftIdlAnnotation;
import com.facebook.drift.codec.metadata.FieldKind;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

abstract class FieldMetadata {
    private Short id;
    private Boolean isLegacyId;
    private Boolean isRecursiveReference;
    private String name;
    private ThriftField.Requiredness requiredness;
    private Map<String, String> idlAnnotations;
    private final FieldKind type;

    protected FieldMetadata(ThriftField annotation, FieldKind type) {
        this.type = type;
        block0 : switch (type) {
            case THRIFT_FIELD: {
                if (annotation == null) break;
                if (annotation.value() != Short.MIN_VALUE) {
                    this.id = annotation.value();
                }
                this.isLegacyId = annotation.isLegacyId();
                if (!annotation.name().isEmpty()) {
                    this.name = annotation.name();
                }
                this.requiredness = Objects.requireNonNull(annotation.requiredness());
                ImmutableMap.Builder annotationMapBuilder = ImmutableMap.builder();
                for (ThriftIdlAnnotation idlAnnotation : annotation.idlAnnotations()) {
                    annotationMapBuilder.put((Object)idlAnnotation.key(), (Object)idlAnnotation.value());
                }
                this.idlAnnotations = annotationMapBuilder.build();
                if (annotation.isRecursive() != ThriftField.Recursiveness.UNSPECIFIED) {
                    switch (annotation.isRecursive()) {
                        case TRUE: {
                            this.isRecursiveReference = true;
                            break block0;
                        }
                        case FALSE: {
                            this.isRecursiveReference = false;
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Unexpected get for isRecursive field");
                }
                if (!this.idlAnnotations.containsKey("drift.recursive_reference")) break;
                this.isRecursiveReference = "true".equalsIgnoreCase(this.idlAnnotations.getOrDefault("drift.recursive_reference", "false"));
                break;
            }
            case THRIFT_UNION_ID: {
                Preconditions.checkArgument((annotation == null ? 1 : 0) != 0, (Object)"ThriftStruct annotation not allowed in union");
                this.id = Short.MIN_VALUE;
                this.isLegacyId = true;
                this.name = "_union_id";
                break;
            }
            default: {
                throw new IllegalArgumentException("Encountered field metadata type " + (Object)((Object)type));
            }
        }
    }

    public Short getId() {
        return this.id;
    }

    public void setId(short id) {
        this.id = id;
    }

    @Nullable
    public Boolean isLegacyId() {
        return this.isLegacyId;
    }

    public void setIsLegacyId(Boolean isLegacyId) {
        this.isLegacyId = isLegacyId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, String> getIdlAnnotations() {
        return this.idlAnnotations;
    }

    public void setIdlAnnotations(Map<String, String> idlAnnotations) {
        this.idlAnnotations = idlAnnotations;
    }

    public FieldKind getType() {
        return this.type;
    }

    public abstract Type getJavaType();

    public abstract String extractName();

    public Optional<Boolean> getThriftFieldIsLegacyId() {
        Boolean value = this.isLegacyId();
        if (!(this.getId() != null && this.getId() != Short.MIN_VALUE || value == null || value.booleanValue())) {
            return Optional.empty();
        }
        return Optional.ofNullable(value);
    }

    public String getOrExtractThriftFieldName() {
        String name = this.getName();
        if (name == null) {
            name = this.extractName();
        }
        if (name == null) {
            throw new IllegalStateException("name is null");
        }
        return name;
    }

    public ThriftField.Requiredness getRequiredness() {
        return this.requiredness;
    }

    public void setRequiredness(ThriftField.Requiredness requiredness) {
        this.requiredness = requiredness;
    }

    @Nullable
    public Boolean isRecursiveReference() {
        return this.isRecursiveReference;
    }

    public void setIsRecursiveReference(Boolean isRecursiveReference) {
        this.isRecursiveReference = isRecursiveReference;
    }
}

