/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.array.Arrays;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockLease;
import com.facebook.presto.spi.block.ClosingBlockLease;
import com.facebook.presto.spi.block.IntArrayBlock;
import com.facebook.presto.spi.block.LongArrayBlock;
import com.facebook.presto.spi.block.ShortArrayBlock;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

abstract class AbstractLongSelectiveStreamReader
implements SelectiveStreamReader {
    protected final boolean outputRequired;
    @Nullable
    protected final Type outputType;
    @Nullable
    protected long[] values;
    @Nullable
    protected boolean[] nulls;
    @Nullable
    protected int[] outputPositions;
    protected int outputPositionCount;
    private int[] intValues;
    private boolean intValuesPopulated;
    private short[] shortValues;
    private boolean shortValuesPopulated;
    private boolean valuesInUse;

    protected AbstractLongSelectiveStreamReader(Optional<Type> outputType) {
        this.outputRequired = Objects.requireNonNull(outputType, "outputType is null").isPresent();
        this.outputType = outputType.orElse(null);
    }

    protected void prepareNextRead(int positionCount, boolean withNulls) {
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.outputRequired) {
            this.ensureValuesCapacity(positionCount, withNulls);
        }
        this.intValuesPopulated = false;
        this.shortValuesPopulated = false;
    }

    @Override
    public int[] getReadPositions() {
        return this.outputPositions;
    }

    @Override
    public void throwAnyError(int[] positions, int positionCount) {
    }

    protected BlockLease buildOutputBlockView(int[] positions, int positionCount, boolean includeNulls) {
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.outputType == BigintType.BIGINT) {
            if (positionCount < this.outputPositionCount) {
                this.compactValues(positions, positionCount, includeNulls);
            }
            return this.newLease((Block)new LongArrayBlock(positionCount, Optional.ofNullable(includeNulls ? this.nulls : null), this.values));
        }
        if (this.outputType == IntegerType.INTEGER || this.outputType == DateType.DATE) {
            if (!this.intValuesPopulated || positionCount < this.outputPositionCount) {
                if (positionCount < this.outputPositionCount) {
                    this.compactValues(positions, positionCount, includeNulls);
                }
                if (this.intValues == null || this.intValues.length < positionCount) {
                    this.intValues = new int[positionCount];
                }
                for (int i = 0; i < positionCount; ++i) {
                    this.intValues[i] = (int)this.values[i];
                }
                this.intValuesPopulated = true;
            }
            return this.newLease((Block)new IntArrayBlock(positionCount, Optional.ofNullable(includeNulls ? this.nulls : null), this.intValues));
        }
        if (this.outputType == SmallintType.SMALLINT) {
            if (!this.shortValuesPopulated || positionCount < this.outputPositionCount) {
                if (positionCount < this.outputPositionCount) {
                    this.compactValues(positions, positionCount, includeNulls);
                }
                if (this.shortValues == null || this.shortValues.length < positionCount) {
                    this.shortValues = new short[positionCount];
                }
                for (int i = 0; i < positionCount; ++i) {
                    this.shortValues[i] = (short)this.values[i];
                }
                this.shortValuesPopulated = true;
            }
            return this.newLease((Block)new ShortArrayBlock(positionCount, Optional.ofNullable(includeNulls ? this.nulls : null), this.shortValues));
        }
        throw new UnsupportedOperationException("Unsupported type: " + this.outputType);
    }

    private BlockLease newLease(Block block) {
        this.valuesInUse = true;
        return ClosingBlockLease.newLease((Block)block, (ClosingBlockLease.Closer[])new ClosingBlockLease.Closer[]{() -> {
            this.valuesInUse = false;
        }});
    }

    protected Block buildOutputBlock(int[] positions, int positionCount, boolean includeNulls) {
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.outputType == BigintType.BIGINT) {
            return this.getLongArrayBlock(positions, positionCount, includeNulls);
        }
        if (this.outputType == IntegerType.INTEGER || this.outputType == DateType.DATE) {
            return this.getIntArrayBlock(positions, positionCount, includeNulls);
        }
        if (this.outputType == SmallintType.SMALLINT) {
            return this.getShortArrayBlock(positions, positionCount, includeNulls);
        }
        throw new UnsupportedOperationException("Unsupported type: " + this.outputType);
    }

    private Block getLongArrayBlock(int[] positions, int positionCount, boolean includeNulls) {
        if (positionCount == this.outputPositionCount) {
            LongArrayBlock block;
            if (includeNulls) {
                block = new LongArrayBlock(positionCount, Optional.ofNullable(this.nulls), this.values);
                this.nulls = null;
            } else {
                block = new LongArrayBlock(positionCount, Optional.empty(), this.values);
            }
            this.values = null;
            return block;
        }
        long[] valuesCopy = new long[positionCount];
        boolean[] nullsCopy = null;
        if (includeNulls) {
            nullsCopy = new boolean[positionCount];
        }
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            assert (this.outputPositions[i] == nextPosition);
            valuesCopy[positionIndex] = this.values[i];
            if (includeNulls) {
                nullsCopy[positionIndex] = this.nulls[i];
            }
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        return new LongArrayBlock(positionCount, Optional.ofNullable(nullsCopy), valuesCopy);
    }

    private Block getIntArrayBlock(int[] positions, int positionCount, boolean includeNulls) {
        if (this.intValuesPopulated && positionCount == this.outputPositionCount) {
            IntArrayBlock block = new IntArrayBlock(positionCount, Optional.ofNullable(includeNulls ? this.nulls : null), this.intValues);
            this.intValues = null;
            this.nulls = null;
            return block;
        }
        int[] valuesCopy = new int[positionCount];
        boolean[] nullsCopy = null;
        if (includeNulls) {
            nullsCopy = new boolean[positionCount];
        }
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            assert (this.outputPositions[i] == nextPosition);
            valuesCopy[positionIndex] = Math.toIntExact(this.values[i]);
            if (includeNulls) {
                nullsCopy[positionIndex] = this.nulls[i];
            }
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        return new IntArrayBlock(positionCount, Optional.ofNullable(nullsCopy), valuesCopy);
    }

    private Block getShortArrayBlock(int[] positions, int positionCount, boolean includeNulls) {
        if (this.shortValuesPopulated && positionCount == this.outputPositionCount) {
            ShortArrayBlock block = new ShortArrayBlock(positionCount, Optional.ofNullable(includeNulls ? this.nulls : null), this.shortValues);
            this.shortValues = null;
            this.nulls = null;
            return block;
        }
        short[] valuesCopy = new short[positionCount];
        boolean[] nullsCopy = null;
        if (includeNulls) {
            nullsCopy = new boolean[positionCount];
        }
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            assert (this.outputPositions[i] == nextPosition);
            valuesCopy[positionIndex] = (short)this.values[i];
            if (includeNulls) {
                nullsCopy[positionIndex] = this.nulls[i];
            }
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        return new ShortArrayBlock(positionCount, Optional.ofNullable(nullsCopy), valuesCopy);
    }

    private void ensureValuesCapacity(int capacity, boolean recordNulls) {
        this.values = Arrays.ensureCapacity((long[])this.values, (int)capacity);
        if (recordNulls) {
            this.nulls = Arrays.ensureCapacity((boolean[])this.nulls, (int)capacity);
        }
    }

    private void compactValues(int[] positions, int positionCount, boolean compactNulls) {
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            assert (this.outputPositions[i] == nextPosition);
            this.values[positionIndex] = this.values[i];
            if (compactNulls) {
                this.nulls[positionIndex] = this.nulls[i];
            }
            this.outputPositions[positionIndex] = nextPosition;
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
        this.outputPositionCount = positionCount;
    }
}

