/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.checkpoint.FloatStreamCheckpoint;
import com.facebook.presto.orc.stream.OrcInputStream;
import com.facebook.presto.orc.stream.ValueInputStream;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import java.io.IOException;

public class FloatInputStream
implements ValueInputStream<FloatStreamCheckpoint> {
    private final OrcInputStream input;

    public FloatInputStream(OrcInputStream input) {
        this.input = input;
    }

    @Override
    public Class<FloatStreamCheckpoint> getCheckpointType() {
        return FloatStreamCheckpoint.class;
    }

    @Override
    public void seekToCheckpoint(FloatStreamCheckpoint checkpoint) throws IOException {
        this.input.seekToCheckpoint(checkpoint.getInputStreamCheckpoint());
    }

    @Override
    public void skip(long items) throws IOException {
        long length = items * 4L;
        this.input.skipFully(length);
    }

    public float next() throws IOException {
        return this.input.readFloat();
    }

    public void nextVector(Type type, int items, BlockBuilder builder) throws IOException {
        for (int i = 0; i < items; ++i) {
            type.writeLong(builder, (long)Float.floatToRawIntBits(this.next()));
        }
    }
}

