/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchMetadata;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.tpch.TpchColumn;
import io.airlift.tpch.TpchColumnType;
import io.airlift.tpch.TpchEntity;
import io.airlift.tpch.TpchTable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TpchRecordSet<E extends TpchEntity>
implements RecordSet {
    private final Iterable<E> rows;
    private final TpchTable<E> table;
    private final List<TpchColumn<E>> columns;
    private final List<Type> columnTypes;
    private final TupleDomain<ColumnHandle> predicate;

    public static <E extends TpchEntity> TpchRecordSet<E> createTpchRecordSet(TpchTable<E> table, double scaleFactor) {
        return TpchRecordSet.createTpchRecordSet(table, table.getColumns(), scaleFactor, 1, 1, (TupleDomain<ColumnHandle>)TupleDomain.all());
    }

    public static <E extends TpchEntity> TpchRecordSet<E> createTpchRecordSet(TpchTable<E> table, List<TpchColumn<E>> columns, double scaleFactor, int part, int partCount, TupleDomain<ColumnHandle> predicate) {
        return new TpchRecordSet<E>(table.createGenerator(scaleFactor, part, partCount), table, columns, predicate);
    }

    public TpchRecordSet(Iterable<E> rows, TpchTable<E> table, List<TpchColumn<E>> columns, TupleDomain<ColumnHandle> predicate) {
        this.rows = Objects.requireNonNull(rows, "rows is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.columnTypes = (List)columns.stream().map(TpchMetadata::getPrestoType).collect(ImmutableList.toImmutableList());
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new TpchRecordCursor<E>(this.rows.iterator(), this.table, this.columns, this.predicate);
    }

    public static final class TpchRecordCursor<E extends TpchEntity>
    implements RecordCursor {
        private final Iterator<E> rows;
        private final TpchTable<E> table;
        private final List<TpchColumn<E>> columns;
        private final TupleDomain<ColumnHandle> predicate;
        private E row;
        private boolean closed;

        public TpchRecordCursor(Iterator<E> rows, TpchTable<E> table, List<TpchColumn<E>> columns, TupleDomain<ColumnHandle> predicate) {
            this.rows = Objects.requireNonNull(rows, "rows is null");
            this.table = Objects.requireNonNull(table, "table is null");
            this.columns = Objects.requireNonNull(columns, "columns is null");
            this.predicate = Objects.requireNonNull(predicate, "predicate is null");
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            return TpchMetadata.getPrestoType(this.getTpchColumn(field));
        }

        public boolean advanceNextPosition() {
            while (!this.closed && this.rows.hasNext()) {
                this.row = (TpchEntity)this.rows.next();
                if (!this.rowMatchesPredicate()) continue;
                return true;
            }
            this.closed = true;
            this.row = null;
            return false;
        }

        public boolean getBoolean(int field) {
            throw new UnsupportedOperationException();
        }

        public long getLong(int field) {
            Preconditions.checkState((this.row != null ? 1 : 0) != 0, (Object)"No current row");
            return this.getLong(this.getTpchColumn(field));
        }

        private long getLong(TpchColumn<E> tpchColumn) {
            if (tpchColumn.getType().getBase() == TpchColumnType.Base.DATE) {
                return tpchColumn.getDate(this.row);
            }
            if (tpchColumn.getType().getBase() == TpchColumnType.Base.INTEGER) {
                return tpchColumn.getInteger(this.row);
            }
            return tpchColumn.getIdentifier(this.row);
        }

        public double getDouble(int field) {
            Preconditions.checkState((this.row != null ? 1 : 0) != 0, (Object)"No current row");
            return this.getDouble(this.getTpchColumn(field));
        }

        private double getDouble(TpchColumn<E> tpchColumn) {
            return tpchColumn.getDouble(this.row);
        }

        public Slice getSlice(int field) {
            Preconditions.checkState((this.row != null ? 1 : 0) != 0, (Object)"No current row");
            return this.getSlice(this.getTpchColumn(field));
        }

        private Slice getSlice(TpchColumn<E> tpchColumn) {
            return Slices.utf8Slice((String)tpchColumn.getString(this.row));
        }

        public Object getObject(int field) {
            throw new UnsupportedOperationException();
        }

        public boolean isNull(int field) {
            return false;
        }

        public void close() {
            this.row = null;
            this.closed = true;
        }

        private boolean rowMatchesPredicate() {
            if (this.predicate.isAll()) {
                return true;
            }
            if (this.predicate.isNone()) {
                return false;
            }
            Map rowMap = (Map)((Map)this.predicate.getDomains().get()).keySet().stream().collect(ImmutableMap.toImmutableMap(column -> column, column -> {
                TpchColumnHandle tpchColumnHandle = (TpchColumnHandle)column;
                Type type = tpchColumnHandle.getType();
                TpchColumn tpchColumn = this.table.getColumn(tpchColumnHandle.getColumnName());
                return NullableValue.of((Type)type, (Object)this.getPrestoObject(tpchColumn, type));
            }));
            TupleDomain rowTupleDomain = TupleDomain.fromFixedValues((Map)rowMap);
            return this.predicate.contains(rowTupleDomain);
        }

        private Object getPrestoObject(TpchColumn<E> column, Type type) {
            if (type.getJavaType() == Long.TYPE) {
                return this.getLong(column);
            }
            if (type.getJavaType() == Double.TYPE) {
                return this.getDouble(column);
            }
            if (type.getJavaType() == Slice.class) {
                return this.getSlice(column);
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported column type %s", type.getDisplayName()));
        }

        private TpchColumn<E> getTpchColumn(int field) {
            return this.columns.get(field);
        }
    }
}

