/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.type.Type;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ThriftColumnHandle
implements ColumnHandle {
    private final String columnName;
    private final Type columnType;
    private final String comment;
    private final boolean hidden;

    @JsonCreator
    public ThriftColumnHandle(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="columnType") Type columnType, @JsonProperty(value="comment") @Nullable String comment, @JsonProperty(value="hidden") boolean hidden) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.comment = comment;
        this.hidden = hidden;
    }

    public ThriftColumnHandle(ColumnMetadata columnMetadata) {
        this(columnMetadata.getName(), columnMetadata.getType(), columnMetadata.getComment(), columnMetadata.isHidden());
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public Type getColumnType() {
        return this.columnType;
    }

    @Nullable
    @JsonProperty
    public String getComment() {
        return this.comment;
    }

    @JsonProperty
    public boolean isHidden() {
        return this.hidden;
    }

    public ColumnMetadata toColumnMetadata() {
        return new ColumnMetadata(this.columnName, this.columnType, this.comment, this.hidden);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ThriftColumnHandle other = (ThriftColumnHandle)obj;
        return Objects.equals(this.columnName, other.columnName) && Objects.equals(this.columnType, other.columnType) && Objects.equals(this.comment, other.comment) && this.hidden == other.hidden;
    }

    public int hashCode() {
        return Objects.hash(this.columnName, this.columnType, this.comment, this.hidden);
    }

    public String toString() {
        return this.columnName + ":" + this.columnType;
    }
}

