/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift;

import com.facebook.drift.TException;
import com.facebook.drift.client.DriftClient;
import com.facebook.presto.connector.thrift.ThriftColumnHandle;
import com.facebook.presto.connector.thrift.ThriftErrorCode;
import com.facebook.presto.connector.thrift.ThriftHeaderProvider;
import com.facebook.presto.connector.thrift.ThriftIndexHandle;
import com.facebook.presto.connector.thrift.ThriftTableHandle;
import com.facebook.presto.connector.thrift.ThriftTableLayoutHandle;
import com.facebook.presto.connector.thrift.ThriftTableMetadata;
import com.facebook.presto.connector.thrift.annotations.ForMetadataRefresh;
import com.facebook.presto.connector.thrift.api.PrestoThriftNullableSchemaName;
import com.facebook.presto.connector.thrift.api.PrestoThriftNullableTableMetadata;
import com.facebook.presto.connector.thrift.api.PrestoThriftSchemaTableName;
import com.facebook.presto.connector.thrift.api.PrestoThriftService;
import com.facebook.presto.connector.thrift.api.PrestoThriftServiceException;
import com.facebook.presto.connector.thrift.util.ThriftExceptions;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorIndexHandle;
import com.facebook.presto.spi.ConnectorResolvedIndex;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.inject.Inject;

public class ThriftMetadata
implements ConnectorMetadata {
    private static final Duration EXPIRE_AFTER_WRITE = new Duration(10.0, TimeUnit.MINUTES);
    private static final Duration REFRESH_AFTER_WRITE = new Duration(2.0, TimeUnit.MINUTES);
    private final DriftClient<PrestoThriftService> client;
    private final ThriftHeaderProvider thriftHeaderProvider;
    private final TypeManager typeManager;
    private final LoadingCache<SchemaTableName, Optional<ThriftTableMetadata>> tableCache;

    @Inject
    public ThriftMetadata(DriftClient<PrestoThriftService> client, ThriftHeaderProvider thriftHeaderProvider, TypeManager typeManager, @ForMetadataRefresh Executor metadataRefreshExecutor) {
        this.client = Objects.requireNonNull(client, "client is null");
        this.thriftHeaderProvider = Objects.requireNonNull(thriftHeaderProvider, "thriftHeaderProvider is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.tableCache = CacheBuilder.newBuilder().expireAfterWrite(EXPIRE_AFTER_WRITE.toMillis(), TimeUnit.MILLISECONDS).refreshAfterWrite(REFRESH_AFTER_WRITE.toMillis(), TimeUnit.MILLISECONDS).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(this::getTableMetadataInternal), (Executor)metadataRefreshExecutor));
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        try {
            return ((PrestoThriftService)this.client.get(this.thriftHeaderProvider.getHeaders(session))).listSchemaNames();
        }
        catch (TException | PrestoThriftServiceException e) {
            throw ThriftExceptions.toPrestoException((Exception)e);
        }
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        return ((Optional)this.tableCache.getUnchecked((Object)tableName)).map(ThriftTableMetadata::getSchemaTableName).map(ThriftTableHandle::new).orElse(null);
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        ThriftTableHandle tableHandle = (ThriftTableHandle)table;
        ThriftTableLayoutHandle layoutHandle = new ThriftTableLayoutHandle(tableHandle.getSchemaName(), tableHandle.getTableName(), desiredColumns, (TupleDomain<ColumnHandle>)constraint.getSummary());
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(new ConnectorTableLayout((ConnectorTableLayoutHandle)layoutHandle), constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        return new ConnectorTableLayout(handle);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        ThriftTableHandle handle = (ThriftTableHandle)tableHandle;
        return this.getRequiredTableMetadata(new SchemaTableName(handle.getSchemaName(), handle.getTableName())).toConnectorTableMetadata();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        try {
            return (List)((PrestoThriftService)this.client.get(this.thriftHeaderProvider.getHeaders(session))).listTables(new PrestoThriftNullableSchemaName(schemaNameOrNull)).stream().map(PrestoThriftSchemaTableName::toSchemaTableName).collect(ImmutableList.toImmutableList());
        }
        catch (TException | PrestoThriftServiceException e) {
            throw ThriftExceptions.toPrestoException((Exception)e);
        }
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return (Map)this.getTableMetadata(session, tableHandle).getColumns().stream().collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, ThriftColumnHandle::new));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((ThriftColumnHandle)columnHandle).toColumnMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        return (Map)this.listTables(session, prefix.getSchemaName()).stream().collect(ImmutableMap.toImmutableMap(Function.identity(), schemaTableName -> this.getRequiredTableMetadata((SchemaTableName)schemaTableName).getColumns()));
    }

    public Optional<ConnectorResolvedIndex> resolveIndex(ConnectorSession session, ConnectorTableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        ThriftTableHandle table = (ThriftTableHandle)tableHandle;
        ThriftTableMetadata tableMetadata = this.getRequiredTableMetadata(new SchemaTableName(table.getSchemaName(), table.getTableName()));
        if (tableMetadata.containsIndexableColumns(indexableColumns)) {
            return Optional.of(new ConnectorResolvedIndex((ConnectorIndexHandle)new ThriftIndexHandle(tableMetadata.getSchemaTableName(), tupleDomain, session), tupleDomain));
        }
        return Optional.empty();
    }

    private ThriftTableMetadata getRequiredTableMetadata(SchemaTableName schemaTableName) {
        Optional table = (Optional)this.tableCache.getUnchecked((Object)schemaTableName);
        if (!table.isPresent()) {
            throw new TableNotFoundException(schemaTableName);
        }
        return (ThriftTableMetadata)table.get();
    }

    private Optional<ThriftTableMetadata> getTableMetadataInternal(SchemaTableName schemaTableName) {
        Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        PrestoThriftNullableTableMetadata thriftTableMetadata = this.getTableMetadata(schemaTableName);
        if (thriftTableMetadata.getTableMetadata() == null) {
            return Optional.empty();
        }
        ThriftTableMetadata tableMetadata = new ThriftTableMetadata(thriftTableMetadata.getTableMetadata(), this.typeManager);
        if (!Objects.equals(schemaTableName, tableMetadata.getSchemaTableName())) {
            throw new PrestoException((ErrorCodeSupplier)ThriftErrorCode.THRIFT_SERVICE_INVALID_RESPONSE, "Requested and actual table names are different");
        }
        return Optional.of(tableMetadata);
    }

    private PrestoThriftNullableTableMetadata getTableMetadata(SchemaTableName schemaTableName) {
        PrestoThriftSchemaTableName name;
        try {
            name = new PrestoThriftSchemaTableName(schemaTableName);
        }
        catch (IllegalArgumentException e) {
            return new PrestoThriftNullableTableMetadata(null);
        }
        try {
            return ((PrestoThriftService)this.client.get()).getTableMetadata(name);
        }
        catch (TException | PrestoThriftServiceException e) {
            throw ThriftExceptions.toPrestoException((Exception)e);
        }
    }
}

