/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift;

import com.facebook.presto.connector.thrift.ThriftConnectorFactory;
import com.facebook.presto.connector.thrift.ThriftPluginInfo;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Module;
import java.util.Objects;
import java.util.ServiceLoader;

public class ThriftPlugin
implements Plugin {
    private final String name;
    private final Module module;

    public ThriftPlugin() {
        this(ThriftPlugin.getPluginInfo());
    }

    private ThriftPlugin(ThriftPluginInfo info) {
        this(info.getName(), info.getModule());
    }

    public ThriftPlugin(String name, Module module) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.module = Objects.requireNonNull(module, "module is null");
    }

    public Iterable<ConnectorFactory> getConnectorFactories() {
        return ImmutableList.of((Object)new ThriftConnectorFactory(this.name, this.module));
    }

    private static ThriftPluginInfo getPluginInfo() {
        ClassLoader classLoader = ThriftPlugin.class.getClassLoader();
        ServiceLoader<ThriftPluginInfo> loader = ServiceLoader.load(ThriftPluginInfo.class, classLoader);
        ImmutableList list = ImmutableList.copyOf(loader);
        return list.isEmpty() ? new ThriftPluginInfo() : (ThriftPluginInfo)Iterables.getOnlyElement((Iterable)list);
    }
}

