/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;

public class HoodieRecord<T extends HoodieRecordPayload>
implements Serializable {
    public static String COMMIT_TIME_METADATA_FIELD = "_hoodie_commit_time";
    public static String COMMIT_SEQNO_METADATA_FIELD = "_hoodie_commit_seqno";
    public static String RECORD_KEY_METADATA_FIELD = "_hoodie_record_key";
    public static String PARTITION_PATH_METADATA_FIELD = "_hoodie_partition_path";
    public static String FILENAME_METADATA_FIELD = "_hoodie_file_name";
    public static final List<String> HOODIE_META_COLUMNS = new ImmutableList.Builder().add((Object)COMMIT_TIME_METADATA_FIELD).add((Object)COMMIT_SEQNO_METADATA_FIELD).add((Object)RECORD_KEY_METADATA_FIELD).add((Object)PARTITION_PATH_METADATA_FIELD).add((Object)FILENAME_METADATA_FIELD).build();
    private HoodieKey key;
    private T data;
    private HoodieRecordLocation currentLocation;
    private HoodieRecordLocation newLocation;
    private boolean sealed;

    public HoodieRecord(HoodieKey key, T data) {
        this.key = key;
        this.data = data;
        this.currentLocation = null;
        this.newLocation = null;
        this.sealed = false;
    }

    public HoodieRecord(HoodieRecord<T> record) {
        this(record.key, record.data);
        this.currentLocation = record.currentLocation;
        this.newLocation = record.newLocation;
        this.sealed = record.sealed;
    }

    public HoodieKey getKey() {
        return this.key;
    }

    public T getData() {
        if (this.data == null) {
            throw new IllegalStateException("Payload already deflated for record.");
        }
        return this.data;
    }

    public void deflate() {
        this.data = null;
    }

    public HoodieRecord setCurrentLocation(HoodieRecordLocation location) {
        this.checkState();
        assert (this.currentLocation == null);
        this.currentLocation = location;
        return this;
    }

    public HoodieRecordLocation getCurrentLocation() {
        return this.currentLocation;
    }

    public HoodieRecord setNewLocation(HoodieRecordLocation location) {
        this.checkState();
        assert (this.newLocation == null);
        this.newLocation = location;
        return this;
    }

    public Option<HoodieRecordLocation> getNewLocation() {
        return Option.ofNullable(this.newLocation);
    }

    public boolean isCurrentLocationKnown() {
        return this.currentLocation != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieRecord that = (HoodieRecord)o;
        return Objects.equal((Object)this.key, (Object)that.key) && Objects.equal(this.data, that.data) && Objects.equal((Object)this.currentLocation, (Object)that.currentLocation) && Objects.equal((Object)this.newLocation, (Object)that.newLocation);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.data, this.currentLocation, this.newLocation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HoodieRecord{");
        sb.append("key=").append(this.key);
        sb.append(", currentLocation='").append(this.currentLocation).append('\'');
        sb.append(", newLocation='").append(this.newLocation).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static String generateSequenceId(String commitTime, int partitionId, long recordIndex) {
        return commitTime + "_" + partitionId + "_" + recordIndex;
    }

    public String getPartitionPath() {
        assert (this.key != null);
        return this.key.getPartitionPath();
    }

    public String getRecordKey() {
        assert (this.key != null);
        return this.key.getRecordKey();
    }

    public void seal() {
        this.sealed = true;
    }

    public void unseal() {
        this.sealed = false;
    }

    public void checkState() {
        if (this.sealed) {
            throw new UnsupportedOperationException("Not allowed to modify after sealed");
        }
    }
}

