/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import org.apache.avro.Schema;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.ObjectSizeCalculator;
import org.apache.hudi.common.util.SizeEstimator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieRecordSizeEstimator<T extends HoodieRecordPayload>
implements SizeEstimator<HoodieRecord<T>> {
    private static final Logger LOG = LogManager.getLogger(HoodieRecordSizeEstimator.class);
    private final Schema schema;

    public HoodieRecordSizeEstimator(Schema schema) {
        this.schema = schema;
    }

    @Override
    public long sizeEstimate(HoodieRecord<T> hoodieRecord) {
        long sizeOfRecord = ObjectSizeCalculator.getObjectSize(hoodieRecord);
        long sizeOfSchema = ObjectSizeCalculator.getObjectSize(this.schema);
        LOG.info((Object)("SizeOfRecord => " + sizeOfRecord + " SizeOfSchema => " + sizeOfSchema));
        return sizeOfRecord;
    }
}

