/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.reflectasm.ConstructorAccess;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.objenesis.instantiator.ObjectInstantiator;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class SerializationUtils {
    private static final ThreadLocal<KryoSerializerInstance> SERIALIZER_REF = ThreadLocal.withInitial(() -> new KryoSerializerInstance());

    public static byte[] serialize(Object obj) throws IOException {
        return SERIALIZER_REF.get().serialize(obj);
    }

    public static <T> T deserialize(byte[] objectData) {
        if (objectData == null) {
            throw new IllegalArgumentException("The byte[] must not be null");
        }
        return (T)SERIALIZER_REF.get().deserialize(objectData);
    }

    private static class KryoInstantiator
    implements Serializable {
        private KryoInstantiator() {
        }

        public Kryo newKryo() {
            KryoBase kryo = new KryoBase();
            kryo.setRegistrationRequired(false);
            kryo.setInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
            kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
            return kryo;
        }

        private static class KryoBase
        extends Kryo {
            private KryoBase() {
            }

            protected Serializer newDefaultSerializer(Class type) {
                Serializer serializer = super.newDefaultSerializer(type);
                if (serializer instanceof FieldSerializer) {
                    FieldSerializer fieldSerializer = (FieldSerializer)serializer;
                    fieldSerializer.setIgnoreSyntheticFields(true);
                }
                return serializer;
            }

            protected ObjectInstantiator newInstantiator(Class type) {
                return () -> {
                    try {
                        ConstructorAccess access = ConstructorAccess.get((Class)type);
                        return access.newInstance();
                    }
                    catch (Throwable access) {
                        try {
                            Constructor constructor = type.getConstructor(new Class[0]);
                            constructor.setAccessible(true);
                            return constructor.newInstance(new Object[0]);
                        }
                        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                            return super.getInstantiatorStrategy().newInstantiatorOf(type).newInstance();
                        }
                    }
                };
            }
        }
    }

    private static class KryoSerializerInstance
    implements Serializable {
        public static final int KRYO_SERIALIZER_INITIAL_BUFFER_SIZE = 0x100000;
        private final Kryo kryo;
        private final ByteArrayOutputStream baos;

        KryoSerializerInstance() {
            KryoInstantiator kryoInstantiator = new KryoInstantiator();
            this.kryo = kryoInstantiator.newKryo();
            this.baos = new ByteArrayOutputStream(0x100000);
            this.kryo.setRegistrationRequired(false);
        }

        byte[] serialize(Object obj) throws IOException {
            this.kryo.reset();
            this.baos.reset();
            Output output = new Output((OutputStream)this.baos);
            this.kryo.writeClassAndObject(output, obj);
            output.close();
            return this.baos.toByteArray();
        }

        Object deserialize(byte[] objectData) {
            return this.kryo.readClassAndObject(new Input(objectData));
        }
    }
}

