/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;

public final class BlockSerdeUtil {
    public static final MethodHandle READ_BLOCK;

    private BlockSerdeUtil() {
    }

    public static Block readBlock(BlockEncodingSerde blockEncodingSerde, Slice slice) {
        return BlockSerdeUtil.readBlock(blockEncodingSerde, (SliceInput)slice.getInput());
    }

    public static Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput input) {
        return blockEncodingSerde.readBlock(input);
    }

    public static void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput output, Block block) {
        blockEncodingSerde.writeBlock(output, block);
    }

    static {
        try {
            READ_BLOCK = MethodHandles.lookup().unreflect(BlockSerdeUtil.class.getMethod("readBlock", BlockEncodingSerde.class, Slice.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }
}

