/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractMapBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.block.EncoderUtil;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSerde;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.util.Optional;

public class MapBlockEncoding
implements BlockEncoding {
    public static final String NAME = "MAP";
    private final TypeManager typeManager;

    public MapBlockEncoding(TypeManager typeManager) {
        this.typeManager = typeManager;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        AbstractMapBlock mapBlock = (AbstractMapBlock)block;
        int positionCount = mapBlock.getPositionCount();
        int offsetBase = mapBlock.getOffsetBase();
        int[] offsets = mapBlock.getOffsets();
        int[] hashTable = mapBlock.getHashTables().get().orElse(null);
        int entriesStartOffset = offsets[offsetBase];
        int entriesEndOffset = offsets[offsetBase + positionCount];
        TypeSerde.writeType(sliceOutput, mapBlock.keyType);
        blockEncodingSerde.writeBlock(sliceOutput, mapBlock.getRawKeyBlock().getRegion(entriesStartOffset, entriesEndOffset - entriesStartOffset));
        blockEncodingSerde.writeBlock(sliceOutput, mapBlock.getRawValueBlock().getRegion(entriesStartOffset, entriesEndOffset - entriesStartOffset));
        if (hashTable != null) {
            int hashTableLength = (entriesEndOffset - entriesStartOffset) * 2;
            sliceOutput.appendInt(hashTableLength);
            sliceOutput.writeBytes(Slices.wrappedIntArray((int[])hashTable, (int)(entriesStartOffset * 2), (int)hashTableLength));
        } else {
            sliceOutput.appendInt(-1);
        }
        sliceOutput.appendInt(positionCount);
        for (int position = 0; position < positionCount + 1; ++position) {
            sliceOutput.writeInt(offsets[offsetBase + position] - entriesStartOffset);
        }
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        Type keyType = TypeSerde.readType(this.typeManager, sliceInput);
        Block keyBlock = blockEncodingSerde.readBlock(sliceInput);
        Block valueBlock = blockEncodingSerde.readBlock(sliceInput);
        int hashTableLength = sliceInput.readInt();
        int[] hashTable = null;
        if (hashTableLength >= 0) {
            hashTable = new int[hashTableLength];
            sliceInput.readBytes(Slices.wrappedIntArray((int[])hashTable));
        }
        if (keyBlock.getPositionCount() != valueBlock.getPositionCount()) {
            throw new IllegalArgumentException(String.format("Deserialized MapBlock violates invariants: key %d, value %d", keyBlock.getPositionCount(), valueBlock.getPositionCount()));
        }
        if (hashTable != null && keyBlock.getPositionCount() * 2 != hashTable.length) {
            throw new IllegalArgumentException(String.format("Deserialized MapBlock violates invariants: expected hashtable size %d, actual hashtable size %d", keyBlock.getPositionCount() * 2, hashTable.length));
        }
        int positionCount = sliceInput.readInt();
        int[] offsets = new int[positionCount + 1];
        sliceInput.readBytes(Slices.wrappedIntArray((int[])offsets));
        Optional<boolean[]> mapIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount);
        return MapType.createMapBlockInternal(this.typeManager, keyType, 0, positionCount, mapIsNull, offsets, keyBlock, valueBlock, new AbstractMapBlock.HashTables(Optional.ofNullable(hashTable), positionCount, hashTableLength));
    }
}

