/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.AbstractMapBlock;
import com.facebook.presto.spi.block.AbstractSingleMapBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.MapBlockBuilder;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class SingleMapBlock
extends AbstractSingleMapBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleMapBlock.class).instanceSize();
    private final int offset;
    private final int positionCount;
    private final AbstractMapBlock mapBlock;

    SingleMapBlock(int offset, int positionCount, AbstractMapBlock mapBlock) {
        this.offset = offset;
        this.positionCount = positionCount;
        this.mapBlock = mapBlock;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        return this.mapBlock.getRawKeyBlock().getRegionSizeInBytes(this.offset / 2, this.positionCount / 2) + this.mapBlock.getRawValueBlock().getRegionSizeInBytes(this.offset / 2, this.positionCount / 2) + SizeOf.sizeOfIntArray((int)(this.positionCount / 2 * 2));
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.mapBlock.getRawKeyBlock().getRetainedSizeInBytes() + this.mapBlock.getRawValueBlock().getRetainedSizeInBytes() + this.mapBlock.getHashTables().getRetainedSizeInBytes();
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.mapBlock.getRawKeyBlock(), this.mapBlock.getRawKeyBlock().getRetainedSizeInBytes());
        consumer.accept(this.mapBlock.getRawValueBlock(), this.mapBlock.getRawValueBlock().getRetainedSizeInBytes());
        consumer.accept(this.mapBlock.getHashTables(), this.mapBlock.getHashTables().getRetainedSizeInBytes());
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public String getEncodingName() {
        return "MAP_ELEMENT";
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    Block getRawKeyBlock() {
        return this.mapBlock.getRawKeyBlock();
    }

    @Override
    Block getRawValueBlock() {
        return this.mapBlock.getRawValueBlock();
    }

    public String toString() {
        return String.format("SingleMapBlock{positionCount=%d}", this.getPositionCount());
    }

    @Override
    public Block getLoadedBlock() {
        if (this.mapBlock.getRawKeyBlock() != this.mapBlock.getRawKeyBlock().getLoadedBlock()) {
            throw new IllegalStateException();
        }
        Block loadedValueBlock = this.mapBlock.getRawValueBlock().getLoadedBlock();
        if (loadedValueBlock == this.mapBlock.getRawValueBlock()) {
            return this;
        }
        return new SingleMapBlock(this.offset, this.positionCount, this.mapBlock);
    }

    @Nullable
    int[] getHashTable() {
        return this.mapBlock.getHashTables().get().orElse(null);
    }

    Type getKeyType() {
        return this.mapBlock.keyType;
    }

    public int seekKey(Object nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        this.mapBlock.ensureHashTableLoaded();
        int[] hashTable = this.mapBlock.getHashTables().get().get();
        try {
            hashCode = this.mapBlock.keyNativeHashCode.invoke(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int position = MapBlockBuilder.computePosition(hashCode, hashTableSize);
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            try {
                match = this.mapBlock.keyBlockNativeEquals.invoke(this.mapBlock.getRawKeyBlock(), this.offset / 2 + keyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            SingleMapBlock.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition * 2 + 1;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    public int seekKeyExact(long nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        this.mapBlock.ensureHashTableLoaded();
        int[] hashTable = this.mapBlock.getHashTables().get().get();
        try {
            hashCode = this.mapBlock.keyNativeHashCode.invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int position = MapBlockBuilder.computePosition(hashCode, hashTableSize);
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            try {
                match = this.mapBlock.keyBlockNativeEquals.invokeExact(this.mapBlock.getRawKeyBlock(), this.offset / 2 + keyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            SingleMapBlock.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition * 2 + 1;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    public int seekKeyExact(boolean nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        this.mapBlock.ensureHashTableLoaded();
        int[] hashTable = this.mapBlock.getHashTables().get().get();
        try {
            hashCode = this.mapBlock.keyNativeHashCode.invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int position = MapBlockBuilder.computePosition(hashCode, hashTableSize);
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            try {
                match = this.mapBlock.keyBlockNativeEquals.invokeExact(this.mapBlock.getRawKeyBlock(), this.offset / 2 + keyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            SingleMapBlock.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition * 2 + 1;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    public int seekKeyExact(double nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        this.mapBlock.ensureHashTableLoaded();
        int[] hashTable = this.mapBlock.getHashTables().get().get();
        try {
            hashCode = this.mapBlock.keyNativeHashCode.invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int position = MapBlockBuilder.computePosition(hashCode, hashTableSize);
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            try {
                match = this.mapBlock.keyBlockNativeEquals.invokeExact(this.mapBlock.getRawKeyBlock(), this.offset / 2 + keyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            SingleMapBlock.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition * 2 + 1;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    public int seekKeyExact(Slice nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        this.mapBlock.ensureHashTableLoaded();
        int[] hashTable = this.mapBlock.getHashTables().get().get();
        try {
            hashCode = this.mapBlock.keyNativeHashCode.invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int position = MapBlockBuilder.computePosition(hashCode, hashTableSize);
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            try {
                match = this.mapBlock.keyBlockNativeEquals.invokeExact(this.mapBlock.getRawKeyBlock(), this.offset / 2 + keyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            SingleMapBlock.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition * 2 + 1;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    public int seekKeyExact(Block nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        this.mapBlock.ensureHashTableLoaded();
        int[] hashTable = this.mapBlock.getHashTables().get().get();
        try {
            hashCode = this.mapBlock.keyNativeHashCode.invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int position = MapBlockBuilder.computePosition(hashCode, hashTableSize);
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            try {
                match = this.mapBlock.keyBlockNativeEquals.invokeExact(this.mapBlock.getRawKeyBlock(), this.offset / 2 + keyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            SingleMapBlock.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition * 2 + 1;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    private static RuntimeException handleThrowable(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof PrestoException) {
            throw (PrestoException)throwable;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, throwable);
    }

    private static void checkNotIndeterminate(Boolean equalsResult) {
        if (equalsResult == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "map key cannot be null or contain nulls");
        }
    }
}

