/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.plan;

import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.plan.Ordering;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class OrderingScheme {
    private final List<Ordering> orderBy;
    private final Map<VariableReferenceExpression, SortOrder> orderings;

    @JsonCreator
    public OrderingScheme(@JsonProperty(value="orderBy") List<Ordering> orderBy) {
        Objects.requireNonNull(orderBy, "orderBy is null");
        OrderingScheme.checkArgument(!orderBy.isEmpty(), "orderBy is empty", new Object[0]);
        this.orderBy = OrderingScheme.immutableListCopyOf(orderBy);
        this.orderings = OrderingScheme.immutableMapCopyOf(orderBy.stream().collect(Collectors.toMap(Ordering::getVariable, Ordering::getSortOrder)));
    }

    @JsonProperty
    public List<Ordering> getOrderBy() {
        return this.orderBy;
    }

    public List<VariableReferenceExpression> getOrderByVariables() {
        return this.orderBy.stream().map(Ordering::getVariable).collect(Collectors.toList());
    }

    public Map<VariableReferenceExpression, SortOrder> getOrderingsMap() {
        return this.orderings;
    }

    public SortOrder getOrdering(VariableReferenceExpression variable) {
        OrderingScheme.checkArgument(this.orderings.containsKey(variable), "No ordering for variable: %s", variable);
        return this.orderings.get(variable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderingScheme that = (OrderingScheme)o;
        return Objects.equals(this.orderBy, that.orderBy) && Objects.equals(this.orderings, that.orderings);
    }

    public int hashCode() {
        return Objects.hash(this.orderBy, this.orderings);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
        stringBuilder.append(" {");
        stringBuilder.append("orderBy='").append(this.orderBy).append('\'');
        stringBuilder.append(", orderings='").append(this.orderings).append('\'');
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private static void checkArgument(boolean condition, String messageFormat, Object ... args) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(messageFormat, args));
        }
    }

    private static <T> Set<T> immutableSetCopyOf(Collection<T> collection) {
        return Collections.unmodifiableSet(new TreeSet<T>(Objects.requireNonNull(collection, "collection is null")));
    }

    private static <T> List<T> immutableListCopyOf(Collection<T> collection) {
        return Collections.unmodifiableList(new ArrayList<T>(Objects.requireNonNull(collection, "collection is null")));
    }

    private static <T, H> Map<T, H> immutableMapCopyOf(Map<T, H> map) {
        return Collections.unmodifiableMap(new TreeMap<T, H>(Objects.requireNonNull(map, "map is null")));
    }
}

