/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import com.google.common.collect.AbstractIterator;
import io.airlift.tpch.Distribution;
import io.airlift.tpch.Distributions;
import io.airlift.tpch.Nation;
import io.airlift.tpch.RandomText;
import io.airlift.tpch.TextPool;
import java.util.Iterator;
import java.util.Objects;

public class NationGenerator
implements Iterable<Nation> {
    private static final int COMMENT_AVERAGE_LENGTH = 72;
    private final Distributions distributions;
    private final TextPool textPool;

    public NationGenerator() {
        this(Distributions.getDefaultDistributions(), TextPool.getDefaultTestPool());
    }

    public NationGenerator(Distributions distributions, TextPool textPool) {
        this.distributions = Objects.requireNonNull(distributions, "distributions is null");
        this.textPool = Objects.requireNonNull(textPool, "textPool is null");
    }

    @Override
    public Iterator<Nation> iterator() {
        return new NationGeneratorIterator(this.distributions.getNations(), this.textPool);
    }

    private static class NationGeneratorIterator
    extends AbstractIterator<Nation> {
        private final Distribution nations;
        private final RandomText commentRandom;
        private int index;

        private NationGeneratorIterator(Distribution nations, TextPool textPool) {
            this.nations = nations;
            this.commentRandom = new RandomText(606179079L, textPool, 72.0);
        }

        protected Nation computeNext() {
            if (this.index >= this.nations.size()) {
                return (Nation)this.endOfData();
            }
            Nation nation = new Nation(this.index, this.index, this.nations.getValue(this.index), this.nations.getWeight(this.index), this.commentRandom.nextValue());
            this.commentRandom.rowFinished();
            ++this.index;
            return nation;
        }
    }
}

