/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.tpch;

import io.airlift.tpch.Supplier;
import io.airlift.tpch.TpchColumn;
import io.airlift.tpch.TpchColumnType;
import io.airlift.tpch.TpchColumnTypes;

public enum SupplierColumn implements TpchColumn<Supplier>
{
    SUPPLIER_KEY("s_suppkey", TpchColumnTypes.IDENTIFIER){

        @Override
        public long getIdentifier(Supplier supplier) {
            return supplier.getSupplierKey();
        }
    }
    ,
    NAME("s_name", TpchColumnTypes.varchar(25L)){

        @Override
        public String getString(Supplier supplier) {
            return supplier.getName();
        }
    }
    ,
    ADDRESS("s_address", TpchColumnTypes.varchar(40L)){

        @Override
        public String getString(Supplier supplier) {
            return supplier.getAddress();
        }
    }
    ,
    NATION_KEY("s_nationkey", TpchColumnTypes.IDENTIFIER){

        @Override
        public long getIdentifier(Supplier supplier) {
            return supplier.getNationKey();
        }
    }
    ,
    PHONE("s_phone", TpchColumnTypes.varchar(15L)){

        @Override
        public String getString(Supplier supplier) {
            return supplier.getPhone();
        }
    }
    ,
    ACCOUNT_BALANCE("s_acctbal", TpchColumnTypes.DOUBLE){

        @Override
        public double getDouble(Supplier supplier) {
            return supplier.getAccountBalance();
        }

        @Override
        public long getIdentifier(Supplier supplier) {
            return supplier.getAccountBalanceInCents();
        }
    }
    ,
    COMMENT("s_comment", TpchColumnTypes.varchar(101L)){

        @Override
        public String getString(Supplier supplier) {
            return supplier.getComment();
        }
    };

    private final String columnName;
    private final TpchColumnType type;

    private SupplierColumn(String columnName, TpchColumnType type) {
        this.columnName = columnName;
        this.type = type;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public TpchColumnType getType() {
        return this.type;
    }

    @Override
    public double getDouble(Supplier supplier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getIdentifier(Supplier supplier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInteger(Supplier supplier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(Supplier supplier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDate(Supplier entity) {
        throw new UnsupportedOperationException();
    }
}

