/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.geospatial;

import com.esri.core.geometry.GeometryException;
import com.facebook.presto.geospatial.serde.EsriGeometrySerde;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.AbstractVariableWidthType;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import io.airlift.slice.Slice;

public class GeometryType
extends AbstractVariableWidthType {
    public static final GeometryType GEOMETRY = new GeometryType();
    public static final String GEOMETRY_TYPE_NAME = "Geometry";

    private GeometryType() {
        super(new TypeSignature(GEOMETRY_TYPE_NAME, new TypeSignatureParameter[0]), Slice.class);
    }

    protected GeometryType(TypeSignature signature) {
        super(signature, Slice.class);
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writeBytesTo(position, 0, block.getSliceLength(position), blockBuilder);
            blockBuilder.closeEntry();
        }
    }

    public Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, block.getSliceLength(position));
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        blockBuilder.writeBytes(value, offset, length).closeEntry();
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Slice slice = block.getSlice(position, 0, block.getSliceLength(position));
        try {
            return EsriGeometrySerde.deserialize((Slice)slice).asText();
        }
        catch (GeometryException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, e.getMessage(), (Throwable)e);
        }
    }
}

