/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractArrayBlock;
import com.facebook.presto.spi.block.ArrayBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.block.EncoderUtil;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;

public class ArrayBlockEncoding
implements BlockEncoding {
    public static final String NAME = "ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        AbstractArrayBlock arrayBlock = (AbstractArrayBlock)block;
        int positionCount = arrayBlock.getPositionCount();
        int offsetBase = arrayBlock.getOffsetBase();
        int[] offsets = arrayBlock.getOffsets();
        int valuesStartOffset = offsets[offsetBase];
        int valuesEndOffset = offsets[offsetBase + positionCount];
        Block values = arrayBlock.getRawElementBlock().getRegion(valuesStartOffset, valuesEndOffset - valuesStartOffset);
        blockEncodingSerde.writeBlock(sliceOutput, values);
        sliceOutput.appendInt(positionCount);
        for (int position = 0; position < positionCount + 1; ++position) {
            sliceOutput.writeInt(offsets[offsetBase + position] - valuesStartOffset);
        }
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        Block values = blockEncodingSerde.readBlock(sliceInput);
        int positionCount = sliceInput.readInt();
        int[] offsets = new int[positionCount + 1];
        sliceInput.readBytes(Slices.wrappedIntArray((int[])offsets));
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount);
        return ArrayBlock.createArrayBlockInternal(0, positionCount, valueIsNull, offsets, values);
    }
}

