/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.statistics;

import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.RangeColumnStatistics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class ColumnStatistics {
    private static final List<RangeColumnStatistics> SINGLE_UNKNOWN_RANGE_STATISTICS = Collections.singletonList(RangeColumnStatistics.builder().build());
    public static final ColumnStatistics UNKNOWN_COLUMN_STATISTICS = ColumnStatistics.builder().build();
    private final Estimate nullsFraction;
    private final List<RangeColumnStatistics> rangeColumnStatistics;

    private ColumnStatistics(Estimate nullsFraction, List<RangeColumnStatistics> rangeColumnStatistics) {
        this.nullsFraction = Objects.requireNonNull(nullsFraction, "nullsFraction can not be null");
        Objects.requireNonNull(rangeColumnStatistics, "rangeColumnStatistics can not be null");
        if (!rangeColumnStatistics.stream().allMatch(Objects::nonNull)) {
            throw new NullPointerException("elements of rangeColumnStatistics can not be null");
        }
        if (rangeColumnStatistics.size() > 1) {
            throw new IllegalArgumentException("Statistics for multiple ranges are not supported");
        }
        if (rangeColumnStatistics.isEmpty()) {
            rangeColumnStatistics = SINGLE_UNKNOWN_RANGE_STATISTICS;
        }
        if (nullsFraction.isValueUnknown() != rangeColumnStatistics.get(0).getFraction().isValueUnknown()) {
            throw new IllegalArgumentException("All or none fraction/nullsFraction must be set");
        }
        this.rangeColumnStatistics = Collections.unmodifiableList(new ArrayList<RangeColumnStatistics>(rangeColumnStatistics));
    }

    public Estimate getNullsFraction() {
        return this.nullsFraction;
    }

    public RangeColumnStatistics getOnlyRangeColumnStatistics() {
        return this.rangeColumnStatistics.get(0);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Estimate nullsFraction = Estimate.unknownValue();
        private List<RangeColumnStatistics> rangeColumnStatistics = new ArrayList<RangeColumnStatistics>();

        public Builder setNullsFraction(Estimate nullsFraction) {
            this.nullsFraction = nullsFraction;
            return this;
        }

        public Builder addRange(Consumer<RangeColumnStatistics.Builder> rangeBuilderConsumer) {
            RangeColumnStatistics.Builder rangeBuilder = RangeColumnStatistics.builder();
            rangeBuilderConsumer.accept(rangeBuilder);
            this.addRange(rangeBuilder.build());
            return this;
        }

        public Builder addRange(RangeColumnStatistics rangeColumnStatistics) {
            this.rangeColumnStatistics.add(rangeColumnStatistics);
            return this;
        }

        public Builder clearRanges() {
            this.rangeColumnStatistics.clear();
            return this;
        }

        public ColumnStatistics build() {
            return new ColumnStatistics(this.nullsFraction, this.rangeColumnStatistics);
        }
    }
}

