/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.type;

import com.facebook.presto.spi.type.NamedType;
import com.facebook.presto.spi.type.ParameterKind;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import java.util.Objects;

public class TypeParameter {
    private final ParameterKind kind;
    private final Object value;

    private TypeParameter(ParameterKind kind, Object value) {
        this.kind = kind;
        this.value = value;
    }

    public static TypeParameter of(Type type) {
        return new TypeParameter(ParameterKind.TYPE, type);
    }

    public static TypeParameter of(long longLiteral) {
        return new TypeParameter(ParameterKind.LONG, longLiteral);
    }

    public static TypeParameter of(NamedType namedType) {
        return new TypeParameter(ParameterKind.NAMED_TYPE, namedType);
    }

    public static TypeParameter of(String variable) {
        return new TypeParameter(ParameterKind.VARIABLE, variable);
    }

    public static TypeParameter of(TypeSignatureParameter parameter, TypeManager typeManager) {
        switch (parameter.getKind()) {
            case TYPE: {
                Type type = typeManager.getType(parameter.getTypeSignature());
                return TypeParameter.of(type);
            }
            case LONG: {
                return TypeParameter.of(parameter.getLongLiteral());
            }
            case NAMED_TYPE: {
                Type type = typeManager.getType(parameter.getNamedTypeSignature().getTypeSignature());
                return TypeParameter.of(new NamedType(parameter.getNamedTypeSignature().getName(), type));
            }
            case VARIABLE: {
                return TypeParameter.of(parameter.getVariable());
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported parameter [%s]", parameter));
    }

    public ParameterKind getKind() {
        return this.kind;
    }

    public <A> A getValue(ParameterKind expectedParameterKind, Class<A> target) {
        if (this.kind != expectedParameterKind) {
            throw new AssertionError((Object)String.format("ParameterKind is [%s] but expected [%s]", new Object[]{this.kind, expectedParameterKind}));
        }
        return target.cast(this.value);
    }

    public boolean isLongLiteral() {
        return this.kind == ParameterKind.LONG;
    }

    public Type getType() {
        return this.getValue(ParameterKind.TYPE, Type.class);
    }

    public Long getLongLiteral() {
        return this.getValue(ParameterKind.LONG, Long.class);
    }

    public NamedType getNamedType() {
        return this.getValue(ParameterKind.NAMED_TYPE, NamedType.class);
    }

    public String getVariable() {
        return this.getValue(ParameterKind.VARIABLE, String.class);
    }

    public String toString() {
        return this.value.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeParameter other = (TypeParameter)o;
        return Objects.equals((Object)this.kind, (Object)other.kind) && Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.value});
    }
}

