/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.block.MethodHandleUtil;
import com.facebook.presto.spi.block.SingleMapBlock;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSerde;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;

public class SingleMapBlockEncoding
implements BlockEncoding {
    public static final String NAME = "MAP_ELEMENT";
    private final TypeManager typeManager;

    public SingleMapBlockEncoding(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        SingleMapBlock singleMapBlock = (SingleMapBlock)block;
        TypeSerde.writeType(sliceOutput, singleMapBlock.keyType);
        int offset = singleMapBlock.getOffset();
        int positionCount = singleMapBlock.getPositionCount();
        blockEncodingSerde.writeBlock(sliceOutput, singleMapBlock.getRawKeyBlock().getRegion(offset / 2, positionCount / 2));
        blockEncodingSerde.writeBlock(sliceOutput, singleMapBlock.getRawValueBlock().getRegion(offset / 2, positionCount / 2));
        int[] hashTable = singleMapBlock.getHashTable();
        sliceOutput.appendInt(positionCount / 2 * 2);
        sliceOutput.writeBytes(Slices.wrappedIntArray((int[])hashTable, (int)(offset / 2 * 2), (int)(positionCount / 2 * 2)));
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        Type keyType = TypeSerde.readType(this.typeManager, sliceInput);
        MethodHandle keyNativeEquals = this.typeManager.resolveOperator(OperatorType.EQUAL, Arrays.asList(keyType, keyType));
        MethodHandle keyBlockNativeEquals = MethodHandleUtil.compose(keyNativeEquals, MethodHandleUtil.nativeValueGetter(keyType));
        MethodHandle keyNativeHashCode = this.typeManager.resolveOperator(OperatorType.HASH_CODE, Collections.singletonList(keyType));
        Block keyBlock = blockEncodingSerde.readBlock(sliceInput);
        Block valueBlock = blockEncodingSerde.readBlock(sliceInput);
        int[] hashTable = new int[sliceInput.readInt()];
        sliceInput.readBytes(Slices.wrappedIntArray((int[])hashTable));
        if (keyBlock.getPositionCount() != valueBlock.getPositionCount() || keyBlock.getPositionCount() * 2 != hashTable.length) {
            throw new IllegalArgumentException(String.format("Deserialized SingleMapBlock violates invariants: key %d, value %d, hash %d", keyBlock.getPositionCount(), valueBlock.getPositionCount(), hashTable.length));
        }
        return new SingleMapBlock(0, keyBlock.getPositionCount() * 2, keyBlock, valueBlock, hashTable, keyType, keyNativeHashCode, keyBlockNativeEquals);
    }
}

