/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractVariableWidthBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockUtil;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class VariableWidthBlock
extends AbstractVariableWidthBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(VariableWidthBlock.class).instanceSize();
    private final int arrayOffset;
    private final int positionCount;
    private final Slice slice;
    private final int[] offsets;
    @Nullable
    private final boolean[] valueIsNull;
    private final long retainedSizeInBytes;
    private final long sizeInBytes;

    public VariableWidthBlock(int positionCount, Slice slice, int[] offsets, Optional<boolean[]> valueIsNull) {
        this(0, positionCount, slice, offsets, valueIsNull.orElse(null));
    }

    VariableWidthBlock(int arrayOffset, int positionCount, Slice slice, int[] offsets, boolean[] valueIsNull) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (slice == null) {
            throw new IllegalArgumentException("slice is null");
        }
        this.slice = slice;
        if (offsets.length - arrayOffset < positionCount + 1) {
            throw new IllegalArgumentException("offsets length is less than positionCount");
        }
        this.offsets = offsets;
        if (valueIsNull != null && valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("valueIsNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.sizeInBytes = (long)(offsets[arrayOffset + positionCount] - offsets[arrayOffset]) + 5L * (long)positionCount;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + slice.getRetainedSize() + SizeOf.sizeOf((boolean[])valueIsNull) + SizeOf.sizeOf((int[])offsets);
    }

    @Override
    protected final int getPositionOffset(int position) {
        return this.offsets[position + this.arrayOffset];
    }

    @Override
    public int getSliceLength(int position) {
        this.checkReadablePosition(position);
        return this.getPositionOffset(position + 1) - this.getPositionOffset(position);
    }

    @Override
    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    @Override
    protected boolean isEntryNull(int position) {
        return this.valueIsNull != null && this.valueIsNull[position + this.arrayOffset];
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        return (long)(this.offsets[this.arrayOffset + position + length] - this.offsets[this.arrayOffset + position]) + 5L * (long)length;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.slice, this.slice.getRetainedSize());
        consumer.accept(this.offsets, SizeOf.sizeOf((int[])this.offsets));
        if (this.valueIsNull != null) {
            consumer.accept(this.valueIsNull, SizeOf.sizeOf((boolean[])this.valueIsNull));
        }
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        int finalLength = 0;
        for (int i = offset; i < offset + length; ++i) {
            finalLength += this.getSliceLength(positions[i]);
        }
        SliceOutput newSlice = Slices.allocate((int)finalLength).getOutput();
        int[] newOffsets = new int[length + 1];
        boolean[] newValueIsNull = null;
        if (this.valueIsNull != null) {
            newValueIsNull = new boolean[length];
        }
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            if (!this.isEntryNull(position)) {
                newSlice.appendBytes(this.slice.getBytes(this.getPositionOffset(position), this.getSliceLength(position)));
            } else if (newValueIsNull != null) {
                newValueIsNull[i] = true;
            }
            newOffsets[i + 1] = newSlice.size();
        }
        return new VariableWidthBlock(0, length, newSlice.slice(), newOffsets, newValueIsNull);
    }

    @Override
    protected Slice getRawSlice(int position) {
        return this.slice;
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new VariableWidthBlock(positionOffset + this.arrayOffset, length, this.slice, this.offsets, this.valueIsNull);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        boolean[] newValueIsNull;
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        int[] newOffsets = BlockUtil.compactOffsets(this.offsets, positionOffset += this.arrayOffset, length);
        Slice newSlice = BlockUtil.compactSlice(this.slice, this.offsets[positionOffset], newOffsets[length]);
        boolean[] blArray = newValueIsNull = this.valueIsNull == null ? null : BlockUtil.compactArray(this.valueIsNull, positionOffset, length);
        if (newOffsets == this.offsets && newSlice == this.slice && newValueIsNull == this.valueIsNull) {
            return this;
        }
        return new VariableWidthBlock(0, length, newSlice, newOffsets, newValueIsNull);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VariableWidthBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append(", slice=").append(this.slice);
        sb.append('}');
        return sb.toString();
    }
}

