/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.plan;

import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class DistinctLimitNode
extends PlanNode {
    private final PlanNode source;
    private final long limit;
    private final boolean partial;
    private final List<VariableReferenceExpression> distinctVariables;
    private final Optional<VariableReferenceExpression> hashVariable;

    @JsonCreator
    public DistinctLimitNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="limit") long limit, @JsonProperty(value="partial") boolean partial, @JsonProperty(value="distinctVariables") List<VariableReferenceExpression> distinctVariables, @JsonProperty(value="hashVariable") Optional<VariableReferenceExpression> hashVariable) {
        super(id);
        this.source = Objects.requireNonNull(source, "source is null");
        DistinctLimitNode.checkArgument(limit >= 0L, "limit must be greater than or equal to zero");
        this.limit = limit;
        this.partial = partial;
        this.distinctVariables = Collections.unmodifiableList(distinctVariables);
        this.hashVariable = Objects.requireNonNull(hashVariable, "hashVariable is null");
        DistinctLimitNode.checkArgument(!hashVariable.isPresent() || !distinctVariables.contains(hashVariable.get()), "distinctVariables should not contain hash variable");
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.unmodifiableList(Collections.singletonList(this.source));
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public long getLimit() {
        return this.limit;
    }

    @JsonProperty
    public boolean isPartial() {
        return this.partial;
    }

    @JsonProperty
    public Optional<VariableReferenceExpression> getHashVariable() {
        return this.hashVariable;
    }

    @JsonProperty
    public List<VariableReferenceExpression> getDistinctVariables() {
        return this.distinctVariables;
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        ArrayList<VariableReferenceExpression> outputVariables = new ArrayList<VariableReferenceExpression>(this.distinctVariables);
        this.hashVariable.ifPresent(outputVariables::add);
        return Collections.unmodifiableList(outputVariables);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitDistinctLimit(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        DistinctLimitNode.checkArgument(newChildren.size() == 1, "Unexpected number of elements in list newChildren");
        return new DistinctLimitNode(this.getId(), newChildren.get(0), this.limit, this.partial, this.distinctVariables, this.hashVariable);
    }

    private static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }
}

